/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.mixin;

import com.unlikepaladin.pfm.utilities.PFMFileUtil;
import com.unlikepaladin.pfm.utilities.Version;
import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TitleScreen.class})
public abstract class PFMTitleScreenMixin
extends Screen {
    @Unique
    private static boolean pfm$firstInit;

    protected PFMTitleScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"init()V"}, at={@At(value="RETURN")})
    public void pfm$showMissingDependencyScreen(CallbackInfo ci) {
        if (pfm$firstInit) {
            return;
        }
        pfm$firstInit = true;
        if (PFMFileUtil.getModLoader() == PFMFileUtil.ModLoader.FABRIC && PFMFileUtil.isModLoaded("sodium") && !PFMFileUtil.isModLoaded("indium")) {
            String reason = "pfm.compat.failure.reason.indiumNotFound";
            String url = "https://modrinth.com/mod/indium/versions?g=1.21.1";
            if (!Version.compareVersions(PFMFileUtil.getVersion("sodium").get(), "0.6")) {
                Minecraft.getInstance().setScreen((Screen)new ConfirmScreen(accepted -> {
                    if (accepted) {
                        try {
                            Util.getPlatform().openUri(new URI(url));
                        }
                        catch (URISyntaxException e) {
                            throw new IllegalStateException(e);
                        }
                    } else {
                        Minecraft.getInstance().destroy();
                    }
                }, (Component)Component.translatable((String)"pfm.compat.failure.title").withStyle(ChatFormatting.RED), (Component)Component.translatable((String)reason), (Component)Component.translatable((String)"pfm.compat.failure.indiumDownload"), (Component)Component.translatable((String)"menu.quit")));
            }
        } else if (PFMFileUtil.isModLoaded("connectormod")) {
            String reason = "pfm.compat.issue.reason.connectorMod";
            Minecraft.getInstance().setScreen((Screen)new ConfirmScreen(accepted -> {
                if (accepted) {
                    try {
                        Util.getPlatform().openUri(new URI("https://github.com/Sinytra/ForgifiedFabricAPI/issues/186"));
                    }
                    catch (URISyntaxException e) {
                        throw new IllegalStateException(e);
                    }
                } else {
                    Minecraft.getInstance().setScreen((Screen)this);
                }
            }, (Component)Component.translatable((String)"pfm.compat.issue.title").withStyle(ChatFormatting.YELLOW), (Component)Component.translatable((String)reason), (Component)Component.translatable((String)"pfm.compat.issue.connectorReport"), (Component)Component.translatable((String)"options.graphics.warning.accept")));
        }
    }
}

