/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.mixin.neoforge;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.DynamicRenderLayerInterface;
import com.unlikepaladin.pfm.blocks.models.AbstractBakedModel;
import com.unlikepaladin.pfm.client.PaladinFurnitureModClient;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Debug(export=true, print=true)
@Mixin(value={ItemBlockRenderTypes.class})
public class PFMRenderLayersNeoForgeMixin {
    @Unique
    private static final Map<BlockState, Object> pfm$renderLayers = new ConcurrentHashMap<BlockState, Object>();

    @Shadow
    @Deprecated(forRemoval=true, since="1.19")
    public static ChunkRenderTypeSet getRenderLayers(BlockState state) {
        throw new AssertionError();
    }

    @Inject(method={"getRenderLayers(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/neoforged/neoforge/client/ChunkRenderTypeSet;"}, at={@At(value="TAIL")}, cancellable=true)
    private static void modifyFurnitureRenderLayer(BlockState state, CallbackInfoReturnable<ChunkRenderTypeSet> cir) {
        if (state.getBlock().getDescriptionId().contains("pfm")) {
            AbstractBakedModel abstractBakedModel;
            VariantBase<?> variant;
            if (!((ChunkRenderTypeSet)cir.getReturnValue()).getClass().isAssignableFrom(ChunkRenderTypeSet.class)) {
                return;
            }
            if (pfm$renderLayers.containsKey(state)) {
                Object previous = pfm$renderLayers.get(state);
                if (previous instanceof Collection) {
                    cir.setReturnValue((Object)ChunkRenderTypeSet.of((Collection)((Collection)previous)));
                } else {
                    cir.setReturnValue((Object)ChunkRenderTypeSet.of((RenderType[])new RenderType[]{(RenderType)previous}));
                }
                return;
            }
            BakedModel bakedModel = Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(state);
            if (bakedModel instanceof AbstractBakedModel && (variant = (abstractBakedModel = (AbstractBakedModel)bakedModel).getVariant(state)) != null) {
                ChunkRenderTypeSet currentRenderTypes;
                ChunkRenderTypeSet baseRenderTypes = PFMRenderLayersNeoForgeMixin.getRenderLayers(variant.getBaseBlock().defaultBlockState());
                ChunkRenderTypeSet combinedRenderTypes = ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{baseRenderTypes, currentRenderTypes = (ChunkRenderTypeSet)cir.getReturnValue()});
                if (combinedRenderTypes.contains(RenderType.cutout()) || combinedRenderTypes.contains(RenderType.translucent()) || combinedRenderTypes.contains(RenderType.cutoutMipped())) {
                    combinedRenderTypes = ChunkRenderTypeSet.intersection((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{combinedRenderTypes, ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.cutout(), RenderType.translucent(), RenderType.cutoutMipped()})});
                }
                cir.setReturnValue((Object)combinedRenderTypes);
                pfm$renderLayers.put(state, List.copyOf(combinedRenderTypes.asList()));
                return;
            }
            if (state.getBlock() instanceof DynamicRenderLayerInterface) {
                RenderType renderLayer = ((DynamicRenderLayerInterface)state.getBlock()).getCustomRenderLayer();
                if (PaladinFurnitureMod.getPFMConfig().isShaderSolidFixOn()) {
                    cir.setReturnValue((Object)(PaladinFurnitureModClient.areShadersOn() ? ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.solid()}) : ChunkRenderTypeSet.of((RenderType[])new RenderType[]{renderLayer})));
                } else {
                    cir.setReturnValue((Object)ChunkRenderTypeSet.of((RenderType[])new RenderType[]{renderLayer}));
                }
            }
        }
    }
}

