/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.neoforge;

import com.google.common.base.Suppliers;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.client.PathPackRPWrapper;
import com.unlikepaladin.pfm.client.neoforge.ColorRegistryNeoForge;
import com.unlikepaladin.pfm.config.PaladinFurnitureModConfig;
import com.unlikepaladin.pfm.registry.dynamic.neoforge.LateBlockRegistryNeoForge;
import com.unlikepaladin.pfm.registry.neoforge.BlockEntityRegistryNeoForge;
import com.unlikepaladin.pfm.registry.neoforge.BlockItemRegistryNeoForge;
import com.unlikepaladin.pfm.registry.neoforge.EntityRegistryNeoForge;
import com.unlikepaladin.pfm.registry.neoforge.ItemGroupRegistryNeoForge;
import com.unlikepaladin.pfm.registry.neoforge.NetworkRegistryNeoForge;
import com.unlikepaladin.pfm.registry.neoforge.RecipeRegistryNeoForge;
import com.unlikepaladin.pfm.registry.neoforge.ScreenHandlerRegistryNeoForge;
import com.unlikepaladin.pfm.registry.neoforge.SoundRegistryNeoForge;
import com.unlikepaladin.pfm.registry.neoforge.StatisticsRegistryNeoForge;
import com.unlikepaladin.pfm.runtime.PFMDataGenerator;
import com.unlikepaladin.pfm.runtime.PFMRuntimeResources;
import com.unlikepaladin.pfm.utilities.Version;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;

@Mod(value="pfm")
public class PaladinFurnitureModNeoForge
extends PaladinFurnitureMod {
    public static PaladinFurnitureModConfig pfmConfig;

    public PaladinFurnitureModNeoForge(IEventBus modEventBus) {
        pfmConfig = new PaladinFurnitureModConfig(FMLPaths.CONFIGDIR.get());
        try {
            pfmConfig.initialize();
        }
        catch (IOException e) {
            GENERAL_LOGGER.error("Failed to initialize Paladin's Furniture configuration, default values will be used instead");
            GENERAL_LOGGER.error("", (Throwable)e);
        }
        this.commonInit();
        modEventBus.register(EntityRegistryNeoForge.class);
        modEventBus.register(BlockItemRegistryNeoForge.class);
        modEventBus.register(StatisticsRegistryNeoForge.class);
        modEventBus.register(ScreenHandlerRegistryNeoForge.class);
        modEventBus.register(RecipeRegistryNeoForge.class);
        modEventBus.register(BlockEntityRegistryNeoForge.class);
        modEventBus.register(SoundRegistryNeoForge.class);
        modEventBus.addListener(NetworkRegistryNeoForge::register);
        modEventBus.addListener(EventPriority.LOW, ColorRegistryNeoForge::registerBlockColors);
        modEventBus.addListener(EventPriority.LOWEST, ColorRegistryNeoForge::registerItemColors);
        LateBlockRegistryNeoForge.addDynamicBlockRegistration(modEventBus);
        PaladinFurnitureMod.isClient = FMLEnvironment.dist == Dist.CLIENT;
        NeoForge.EVENT_BUS.addListener(NetworkRegistryNeoForge::onServerJoin);
        modEventBus.addListener(ItemGroupRegistryNeoForge::registerItemGroups);
        modEventBus.addListener(ItemGroupRegistryNeoForge::addToVanillaItemGroups);
        modEventBus.addListener(PaladinFurnitureModNeoForge::generateResources);
    }

    @SubscribeEvent
    public static void generateResources(AddPackFindersEvent event) {
        int data = SharedConstants.getCurrentVersion().getPackVersion(PackType.SERVER_DATA);
        int resource = SharedConstants.getCurrentVersion().getPackVersion(PackType.CLIENT_RESOURCES);
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            final PackMetadataSection packResourceMetadata = new PackMetadataSection((Component)Component.literal((String)"Runtime Generated Assets for PFM"), SharedConstants.getCurrentVersion().getPackVersion(PackType.CLIENT_RESOURCES), Optional.empty());
            Pack.ResourcesSupplier packFactory = new Pack.ResourcesSupplier(){

                public PackResources openPrimary(PackLocationInfo info) {
                    return new PathPackRPWrapper((Supplier<PackResources>)Suppliers.memoize(() -> {
                        if (!PFMDataGenerator.areAssetsRunning()) {
                            PFMRuntimeResources.prepareAndRunAssetGen(false);
                        }
                        return PFMRuntimeResources.getAssetsPack(info);
                    }), packResourceMetadata, info);
                }

                public PackResources openFull(PackLocationInfo info, Pack.Metadata metadata) {
                    return this.openPrimary(info);
                }
            };
            event.addRepositorySource(profileAdder -> profileAdder.accept(Pack.readMetaAndCreate((PackLocationInfo)new PackLocationInfo("pfm-asset-resources", (Component)Component.literal((String)"PFM Assets"), PackSource.DEFAULT, Optional.of(new KnownPack("pfm", "pfm_assets", Version.getCurrentVersion()))), (Pack.ResourcesSupplier)packFactory, (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(true, Pack.Position.BOTTOM, false))));
        } else if (event.getPackType() == PackType.SERVER_DATA) {
            final PackMetadataSection packResourceMetadata = new PackMetadataSection((Component)Component.literal((String)"Runtime Generated Data for PFM"), SharedConstants.getCurrentVersion().getPackVersion(PackType.SERVER_DATA), Optional.empty());
            Pack.ResourcesSupplier packFactory = new Pack.ResourcesSupplier(){

                public PackResources openPrimary(PackLocationInfo info) {
                    return new PathPackRPWrapper((Supplier<PackResources>)Suppliers.memoize(() -> {
                        if (!PFMDataGenerator.isDataRunning()) {
                            PFMRuntimeResources.prepareAndRunDataGen(false);
                        }
                        return PFMRuntimeResources.getDataPack(info);
                    }), packResourceMetadata, info);
                }

                public PackResources openFull(PackLocationInfo info, Pack.Metadata metadata) {
                    return this.openPrimary(info);
                }
            };
            event.addRepositorySource(profileAdder -> profileAdder.accept(Pack.readMetaAndCreate((PackLocationInfo)new PackLocationInfo("pfm-data-resources", (Component)Component.literal((String)"PFM Data"), PackSource.DEFAULT, Optional.of(new KnownPack("pfm", "pfm_data", Version.getCurrentVersion()))), (Pack.ResourcesSupplier)packFactory, (PackType)PackType.SERVER_DATA, (PackSelectionConfig)new PackSelectionConfig(true, Pack.Position.BOTTOM, false))));
        }
    }
}

