/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.networking;

import com.unlikepaladin.pfm.blocks.blockentities.MicrowaveBlockEntity;
import com.unlikepaladin.pfm.registry.NetworkIDs;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public record MicrowaveActivatePayload(BlockPos pos, Boolean isActive) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, MicrowaveActivatePayload> PACKET_CODEC = CustomPacketPayload.codec(MicrowaveActivatePayload::write, MicrowaveActivatePayload::new);
    public static final StreamCodec<FriendlyByteBuf, MicrowaveActivatePayload> PACKET_SIMPLE_CODEC = CustomPacketPayload.codec(MicrowaveActivatePayload::write, MicrowaveActivatePayload::new);

    public MicrowaveActivatePayload(RegistryFriendlyByteBuf buf) {
        this(buf.readBlockPos(), buf.readBoolean());
    }

    public MicrowaveActivatePayload(FriendlyByteBuf buf) {
        this(buf.readBlockPos(), buf.readBoolean());
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeBoolean(this.isActive.booleanValue());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeBoolean(this.isActive.booleanValue());
    }

    public void handle(MinecraftServer server, ServerPlayer player) {
        server.executeBlocking(() -> {
            if (Objects.nonNull(player.level().getBlockEntity(this.pos))) {
                Level world = player.level();
                if (world.hasChunkAt(this.pos)) {
                    MicrowaveBlockEntity microwaveBlockEntity = (MicrowaveBlockEntity)world.getBlockEntity(this.pos);
                    microwaveBlockEntity.setActive(this.isActive);
                } else {
                    player.displayClientMessage(Component.nullToEmpty((String)"Trying to access unloaded chunks, are you cheating?"), false);
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return NetworkIDs.MICROWAVE_ACTIVATE_PACKET_ID;
    }
}

