/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.networking;

import com.google.common.collect.Lists;
import com.unlikepaladin.pfm.config.option.AbstractConfigOption;
import com.unlikepaladin.pfm.registry.NetworkIDs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public final class SyncConfigPayload
implements CustomPacketPayload {
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncConfigPayload> PACKET_CODEC = CustomPacketPayload.codec(SyncConfigPayload::write, SyncConfigPayload::new);
    public static final StreamCodec<FriendlyByteBuf, SyncConfigPayload> PACKET_SIMPLE_CODEC = CustomPacketPayload.codec(SyncConfigPayload::write, SyncConfigPayload::new);
    private final Map<String, AbstractConfigOption> configOptionMap;

    public SyncConfigPayload(Map<String, AbstractConfigOption> configOptionMap) {
        this.configOptionMap = configOptionMap;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return NetworkIDs.CONFIG_SYNC_ID;
    }

    public SyncConfigPayload(RegistryFriendlyByteBuf buf) {
        this((FriendlyByteBuf)buf);
    }

    public SyncConfigPayload(FriendlyByteBuf buf) {
        ArrayList configOptions = (ArrayList)buf.readCollection(Lists::newArrayListWithCapacity, AbstractConfigOption::readConfigOption);
        HashMap<String, AbstractConfigOption> map = new HashMap<String, AbstractConfigOption>();
        configOptions.forEach(abstractConfigOption -> map.put(((TranslatableContents)abstractConfigOption.getTitle().getContents()).getKey(), (AbstractConfigOption)abstractConfigOption));
        this.configOptionMap = map;
    }

    public Map<String, AbstractConfigOption> configOptionMap() {
        return this.configOptionMap;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        this.write((FriendlyByteBuf)buf);
    }

    public void write(FriendlyByteBuf buf) {
        Collection<AbstractConfigOption> configOptions = this.configOptionMap.values();
        buf.writeCollection(configOptions, AbstractConfigOption::writeConfigOption);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SyncConfigPayload that = (SyncConfigPayload)obj;
        return Objects.equals(this.configOptionMap, that.configOptionMap);
    }

    public int hashCode() {
        return Objects.hash(this.configOptionMap);
    }

    public String toString() {
        return "SyncConfigPayload[configOptionMap=" + String.valueOf(this.configOptionMap) + "]";
    }
}

