/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.networking;

import com.unlikepaladin.pfm.blocks.BasicToiletBlock;
import com.unlikepaladin.pfm.blocks.ToiletState;
import com.unlikepaladin.pfm.registry.NetworkIDs;
import com.unlikepaladin.pfm.registry.SoundIDs;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public record ToiletUsePayload(BlockPos pos) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, ToiletUsePayload> PACKET_CODEC = CustomPacketPayload.codec(ToiletUsePayload::write, ToiletUsePayload::new);
    public static final StreamCodec<FriendlyByteBuf, ToiletUsePayload> PACKET_SIMPLE_CODEC = CustomPacketPayload.codec(ToiletUsePayload::write, ToiletUsePayload::new);

    public ToiletUsePayload(RegistryFriendlyByteBuf registryByteBuf) {
        this(registryByteBuf.readBlockPos());
    }

    public ToiletUsePayload(FriendlyByteBuf registryByteBuf) {
        this(registryByteBuf.readBlockPos());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return NetworkIDs.TOILET_USE_ID;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
    }

    public void handle(MinecraftServer server, ServerPlayer player) {
        BlockPos blockPos = this.pos();
        server.executeBlocking(() -> {
            Level world = player.level();
            if (world.hasChunkAt(blockPos)) {
                world.setBlockAndUpdate(blockPos, (BlockState)world.getBlockState(blockPos).setValue(BasicToiletBlock.TOILET_STATE, (Comparable)((Object)ToiletState.DIRTY)));
                world.playSound(null, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), SoundIDs.TOILET_USED_EVENT, SoundSource.BLOCKS, 0.3f, world.random.nextFloat() * 0.1f + 0.9f);
            } else {
                player.displayClientMessage(Component.nullToEmpty((String)"Trying to access unloaded chunks, are you cheating?"), false);
            }
        });
    }
}

