/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.recipes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.RawLogTableBlock;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.VariantHelper;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.items.PFMComponents;
import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class DynamicFurnitureRecipe
implements FurnitureRecipe {
    private final String group;
    private final FurnitureOutput furnitureOutput;
    private final List<ResourceLocation> supportedVariants;
    private final FurnitureIngredients ingredients;
    Map<ResourceLocation, List<FurnitureInnerRecipe>> furnitureInnerRecipes = Maps.newHashMap();
    Map<ItemStack, FurnitureInnerRecipe> outputToInnerRecipe = new HashMap<ItemStack, FurnitureInnerRecipe>();
    Map<Item, FurnitureInnerRecipe> outputItemToInnerRecipe = new HashMap<Item, FurnitureInnerRecipe>();

    public DynamicFurnitureRecipe(String group, FurnitureOutput furnitureOutput, List<ResourceLocation> supportedVariants, FurnitureIngredients furnitureIngredients) {
        this.group = group;
        this.furnitureOutput = furnitureOutput;
        this.supportedVariants = supportedVariants;
        this.ingredients = furnitureIngredients;
    }

    public void constructInnerRecipes() {
        if (!this.furnitureInnerRecipes.isEmpty()) {
            return;
        }
        for (ResourceLocation id : this.supportedVariants) {
            WoodVariant woodVariant;
            Optional<Block> optionalOutput;
            VariantBase<?> variant = VariantHelper.getVariant(id);
            if (variant == null || this.furnitureInnerRecipes.containsKey(id)) continue;
            DataComponentPatch componentChanges = this.furnitureOutput.components != null ? this.furnitureOutput.components : DataComponentPatch.EMPTY;
            DataComponentMap.Builder builder = DataComponentMap.builder();
            if (!componentChanges.isEmpty() && componentChanges.entrySet().stream().anyMatch(dataComponentTypeOptionalEntry -> dataComponentTypeOptionalEntry.getKey() == PFMComponents.COLOR_COMPONENT)) {
                optionalOutput = PaladinFurnitureMod.furnitureEntryMap.get(this.getOutputBlockClass()).getEntryFromVariantAndColor(variant, (DyeColor)componentChanges.get(PFMComponents.COLOR_COMPONENT).get());
                if (!optionalOutput.get().asItem().components().has(PFMComponents.COLOR_COMPONENT)) {
                    componentChanges = componentChanges.forget(dataComponentType -> dataComponentType == PFMComponents.COLOR_COMPONENT);
                    PatchedDataComponentMap.fromPatch((DataComponentMap)optionalOutput.get().asItem().components(), (DataComponentPatch)componentChanges);
                } else {
                    builder.addAll((DataComponentMap)PatchedDataComponentMap.fromPatch((DataComponentMap)optionalOutput.get().asItem().components(), (DataComponentPatch)componentChanges));
                }
            } else {
                optionalOutput = PaladinFurnitureMod.furnitureEntryMap.get(this.getOutputBlockClass()).getEntryFromVariant(variant);
                builder.addAll((DataComponentMap)PatchedDataComponentMap.fromPatch((DataComponentMap)optionalOutput.get().asItem().components(), (DataComponentPatch)componentChanges));
            }
            if (optionalOutput.isEmpty()) continue;
            if (optionalOutput.get().asItem().components().has(PFMComponents.VARIANT_COMPONENT)) {
                builder.set(PFMComponents.VARIANT_COMPONENT, (Object)variant.identifier);
            }
            ItemStack output = new ItemStack((ItemLike)optionalOutput.get().asItem(), this.furnitureOutput.getOutputCount());
            DataComponentMap finalComponents = builder.build();
            if (!finalComponents.isEmpty()) {
                output.applyComponents(builder.build());
            }
            Map<String, Integer> childrenToCountMap = this.ingredients.variantChildren;
            boolean abortVariant = false;
            ArrayList stacks = Lists.newArrayList();
            for (Map.Entry<String, Integer> entry : childrenToCountMap.entrySet()) {
                ItemLike convertible = variant.getItemForRecipe(entry.getKey(), this.getOutputBlockClass());
                if (convertible == null || convertible.asItem() == Items.AIR) {
                    abortVariant = true;
                    break;
                }
                stacks.add(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)convertible.asItem(), entry.getValue().intValue())}));
            }
            if (abortVariant) {
                PaladinFurnitureMod.GENERAL_LOGGER.warn("Skipped constructing inner recipe for variant {} on recipe {}", (Object)variant.identifier, (Object)this.furnitureOutput.outputClass);
                continue;
            }
            ArrayList<FurnitureInnerRecipe> recipes = new ArrayList<FurnitureInnerRecipe>();
            FurnitureInnerRecipe recipe = new FurnitureInnerRecipe(this, output, stacks);
            recipes.add(recipe);
            if (variant instanceof WoodVariant && (woodVariant = (WoodVariant)variant).hasStripped()) {
                Optional<Block> strippedOptional;
                ArrayList strippedIngredients = Lists.newArrayList();
                for (Map.Entry<String, Integer> entry : childrenToCountMap.entrySet()) {
                    strippedIngredients.add(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack(woodVariant.getItemForRecipe(entry.getKey(), this.getOutputBlockClass(), true), entry.getValue().intValue())}));
                }
                if (this.getOutputBlockClass() == RawLogTableBlock.class) {
                    strippedIngredients.set(0, Ingredient.of((ItemLike[])new ItemLike[]{(Block)woodVariant.getChild("stripped_log")}));
                }
                if ((strippedOptional = PaladinFurnitureMod.furnitureEntryMap.get(this.getOutputBlockClass()).getEntryFromVariant(variant, true)).isPresent()) {
                    ItemStack strippedOutput = new ItemStack((ItemLike)strippedOptional.get(), this.furnitureOutput.getOutputCount());
                    if (!finalComponents.isEmpty()) {
                        strippedOutput.applyComponents(finalComponents);
                    }
                    FurnitureInnerRecipe stripped = new FurnitureInnerRecipe(this, strippedOutput, strippedIngredients);
                    recipes.add(stripped);
                }
            }
            this.furnitureInnerRecipes.put(id, recipes);
        }
    }

    public boolean matches(FurnitureRecipe.FurnitureRecipeInput inventory, Level world) {
        this.constructInnerRecipes();
        for (ResourceLocation id : this.furnitureInnerRecipes.keySet()) {
            List<FurnitureInnerRecipe> recipes = this.furnitureInnerRecipes.get(id);
            for (FurnitureInnerRecipe recipe : recipes) {
                if (!recipe.matches(inventory, world)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<FurnitureRecipe.CraftableFurnitureRecipe> getAvailableOutputs(FurnitureRecipe.FurnitureRecipeInput input, HolderLookup.Provider registryManager) {
        this.constructInnerRecipes();
        Inventory inventory = input.playerInventory();
        ArrayList stacks = Lists.newArrayList();
        for (ResourceLocation id : this.furnitureInnerRecipes.keySet()) {
            List<FurnitureInnerRecipe> recipes = this.furnitureInnerRecipes.get(id);
            for (FurnitureInnerRecipe recipe : recipes) {
                if (!recipe.matches(input, inventory.player.level())) continue;
                stacks.add(recipe);
            }
        }
        return stacks;
    }

    @Override
    public List<FurnitureRecipe.CraftableFurnitureRecipe> getInnerRecipes() {
        this.constructInnerRecipes();
        ArrayList<FurnitureRecipe.CraftableFurnitureRecipe> outputs = new ArrayList<FurnitureRecipe.CraftableFurnitureRecipe>();
        for (List<FurnitureInnerRecipe> recipes : this.furnitureInnerRecipes.values()) {
            outputs.addAll(recipes);
        }
        return outputs;
    }

    @Override
    public String outputClass() {
        return this.furnitureOutput.outputClass;
    }

    public ItemStack craft(FurnitureRecipe.FurnitureRecipeInput inventory, HolderLookup.Provider registryManager) {
        PaladinFurnitureMod.GENERAL_LOGGER.warn("Something has tried to craft a dynamic furniture recipe without context");
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryManager) {
        PaladinFurnitureMod.GENERAL_LOGGER.warn("Something has tried to get the output of a dynamic furniture recipe without context");
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipeTypes.DYNAMIC_FURNITURE_SERIALIZER;
    }

    protected Class<? extends Block> getOutputBlockClass() {
        return FurnitureOutput.getOutputBlockClass(this.furnitureOutput.outputClass);
    }

    public List<ResourceLocation> getSupportedVariants() {
        return this.supportedVariants;
    }

    @Override
    public int getOutputCount(HolderLookup.Provider registryManager) {
        return this.furnitureOutput.getOutputCount();
    }

    @Override
    public FurnitureRecipe.CraftableFurnitureRecipe getInnerRecipeFromOutput(ItemStack stack) {
        this.constructInnerRecipes();
        if (this.outputToInnerRecipe.containsKey(stack)) {
            return this.outputToInnerRecipe.get(stack);
        }
        return this.outputItemToInnerRecipe.get(stack.getItem());
    }

    @Override
    public int getMaxInnerRecipeSize() {
        return this.ingredients.vanillaIngredients.size() + this.ingredients.variantChildren.size();
    }

    @Override
    public List<? extends FurnitureRecipe.CraftableFurnitureRecipe> getInnerRecipesForVariant(ResourceLocation identifier) {
        this.constructInnerRecipes();
        if (this.furnitureInnerRecipes.containsKey(identifier)) {
            return this.furnitureInnerRecipes.get(identifier);
        }
        return List.of();
    }

    @Override
    public String getName(HolderLookup.Provider registryManager) {
        return this.outputClass().replaceAll("(?<=[a-z])(?=[A-Z])", " ");
    }

    private FurnitureOutput getOutput() {
        return this.furnitureOutput;
    }

    private FurnitureIngredients getInnerIngredients() {
        return this.ingredients;
    }

    public static class FurnitureOutput {
        public static MapCodec<FurnitureOutput> CODEC = RecordCodecBuilder.mapCodec(furnitureOutputInstance -> furnitureOutputInstance.group((App)Codec.STRING.fieldOf("outputClass").forGetter(out -> out.outputClass), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(out -> out.outputCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(out -> out.components)).apply((Applicative)furnitureOutputInstance, FurnitureOutput::new));
        private final String outputClass;
        private final int outputCount;
        private final DataComponentPatch components;

        public FurnitureOutput(String outputClass, int outputCount, DataComponentPatch components) {
            this.outputClass = outputClass;
            this.outputCount = outputCount;
            this.components = components;
        }

        public int getOutputCount() {
            return this.outputCount;
        }

        public DataComponentPatch getComponents() {
            return this.components;
        }

        public String getOutputClass() {
            return this.outputClass;
        }

        public static FurnitureOutput read(RegistryFriendlyByteBuf buf) {
            String outputClass = buf.readUtf();
            int count = buf.readInt();
            DataComponentPatch componentChanges = (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode((Object)buf);
            return new FurnitureOutput(outputClass, count, componentChanges);
        }

        public static void write(RegistryFriendlyByteBuf buf, FurnitureOutput output) {
            buf.writeUtf(output.outputClass);
            buf.writeInt(output.outputCount);
            DataComponentPatch.STREAM_CODEC.encode((Object)buf, (Object)output.components);
        }

        public static Class<? extends Block> getOutputBlockClass(String outputClass) {
            try {
                return Class.forName("com.unlikepaladin.pfm.blocks." + outputClass);
            }
            catch (ClassCastException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class FurnitureIngredients {
        public static Codec<FurnitureIngredients> CODEC = RecordCodecBuilder.create(furnitureIngredientsInstance -> furnitureIngredientsInstance.group((App)Ingredient.CODEC_NONEMPTY.listOf().optionalFieldOf("vanillaIngredients", new ArrayList()).forGetter(ingredients -> ingredients.vanillaIngredients), (App)ExtraCodecs.strictUnboundedMap((Codec)Codec.STRING, (Codec)Codec.INT).fieldOf("variantChildren").forGetter(ingredients -> ingredients.variantChildren)).apply((Applicative)furnitureIngredientsInstance, FurnitureIngredients::new));
        private final List<Ingredient> vanillaIngredients;
        private final Map<String, Integer> variantChildren;

        public FurnitureIngredients(List<Ingredient> vanillaIngredients, Map<String, Integer> variantChildren) {
            this.vanillaIngredients = vanillaIngredients;
            this.variantChildren = variantChildren;
        }

        public static FurnitureIngredients read(RegistryFriendlyByteBuf buf) {
            List vanillaIngredients = (List)buf.readCollection(Lists::newArrayListWithCapacity, buf1 -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf));
            Map variantChildren = buf.readMap(FriendlyByteBuf::readUtf, FriendlyByteBuf::readInt);
            return new FurnitureIngredients(vanillaIngredients, variantChildren);
        }

        public static void write(RegistryFriendlyByteBuf buf, FurnitureIngredients ingredients) {
            buf.writeCollection(ingredients.vanillaIngredients, (packetByteBuf, ingredient) -> Ingredient.CONTENTS_STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)packetByteBuf), ingredient));
            buf.writeMap(ingredients.variantChildren, FriendlyByteBuf::writeUtf, FriendlyByteBuf::writeInt);
        }
    }

    public static final class FurnitureInnerRecipe
    implements FurnitureRecipe.CraftableFurnitureRecipe {
        private final DynamicFurnitureRecipe parentRecipe;
        private final ItemStack output;
        private final List<Ingredient> ingredients;
        private final List<Ingredient> combinedIngredients;

        public FurnitureInnerRecipe(DynamicFurnitureRecipe parentRecipe, ItemStack output, List<Ingredient> ingredients) {
            this.parentRecipe = parentRecipe;
            this.output = output;
            this.ingredients = ingredients;
            this.combinedIngredients = Lists.newArrayList();
            this.combinedIngredients.addAll(ingredients);
            this.combinedIngredients.addAll(parentRecipe.ingredients.vanillaIngredients);
            parentRecipe.outputToInnerRecipe.put(output, this);
            parentRecipe.outputItemToInnerRecipe.put(output.getItem(), this);
        }

        @Override
        public ItemStack getResultItem(HolderLookup.Provider registryManager) {
            return this.output;
        }

        @Override
        public List<Ingredient> getIngredients() {
            return this.combinedIngredients;
        }

        @Override
        public boolean matches(FurnitureRecipe.FurnitureRecipeInput inventory, Level world) {
            List<Ingredient> allIngredients = this.getIngredients();
            BitSet hasIngredient = new BitSet(allIngredients.size());
            block0: for (int i = 0; i < allIngredients.size(); ++i) {
                Ingredient ingredient = allIngredients.get(i);
                for (ItemStack stack : ingredient.getItems()) {
                    int countInInventory = inventory.playerInventory().countItem(stack.getItem());
                    if (countInInventory < stack.getCount()) continue;
                    hasIngredient.set(i, true);
                    continue block0;
                }
            }
            return hasIngredient.cardinality() == allIngredients.size();
        }

        @Override
        public FurnitureRecipe parent() {
            return this.parentRecipe;
        }

        @Override
        public ItemStack craft(FurnitureRecipe.FurnitureRecipeInput inventory, HolderLookup.Provider registryManager) {
            return this.output.copy();
        }

        @Override
        public ItemStack getRecipeOuput() {
            return this.output;
        }
    }

    public static class Serializer
    implements RecipeSerializer<DynamicFurnitureRecipe> {
        MapCodec<DynamicFurnitureRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(Recipe::getGroup), (App)FurnitureOutput.CODEC.fieldOf("result").forGetter(DynamicFurnitureRecipe::getOutput), (App)ResourceLocation.CODEC.listOf().fieldOf("supportedVariants").forGetter(DynamicFurnitureRecipe::getSupportedVariants), (App)FurnitureIngredients.CODEC.fieldOf("ingredients").forGetter(DynamicFurnitureRecipe::getInnerIngredients)).apply((Applicative)instance, DynamicFurnitureRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DynamicFurnitureRecipe> PACKET_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        public MapCodec<DynamicFurnitureRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DynamicFurnitureRecipe> streamCodec() {
            return PACKET_CODEC;
        }

        public static DynamicFurnitureRecipe read(RegistryFriendlyByteBuf buf) {
            String group = buf.readUtf();
            List supportedVariants = buf.readList(FriendlyByteBuf::readResourceLocation);
            FurnitureIngredients ingredients = FurnitureIngredients.read(buf);
            FurnitureOutput output = FurnitureOutput.read(buf);
            return new DynamicFurnitureRecipe(group, output, supportedVariants, ingredients);
        }

        public static void write(RegistryFriendlyByteBuf buf, DynamicFurnitureRecipe recipe) {
            buf.writeUtf(recipe.group);
            buf.writeCollection(recipe.supportedVariants, FriendlyByteBuf::writeResourceLocation);
            FurnitureIngredients.write(buf, recipe.ingredients);
            FurnitureOutput.write(buf, recipe.furnitureOutput);
        }
    }
}

