/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.recipes;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public interface FurnitureRecipe
extends Recipe<FurnitureRecipeInput> {
    default public RecipeType<?> getType() {
        return RecipeTypes.FURNITURE_RECIPE;
    }

    public List<CraftableFurnitureRecipe> getInnerRecipes();

    public String outputClass();

    default public List<CraftableFurnitureRecipe> getAvailableOutputs(FurnitureRecipeInput inventory, HolderLookup.Provider registryManager) {
        return this.getInnerRecipes();
    }

    default public CraftableFurnitureRecipe getInnerRecipeFromOutput(ItemStack stack) {
        return this.getInnerRecipes().get(0);
    }

    public static int getSlotWithStackIgnoreNBT(Inventory inventory, ItemStack stack) {
        for (int i = 0; i < inventory.items.size(); ++i) {
            if (((ItemStack)inventory.items.get(i)).isEmpty() || !stack.is(((ItemStack)inventory.items.get(i)).getItem())) continue;
            return i;
        }
        return -1;
    }

    default public int getMaxInnerRecipeSize() {
        return this.getIngredients().size();
    }

    default public int getOutputCount(HolderLookup.Provider registryManager) {
        return this.getResultItem(registryManager).getCount();
    }

    default public List<? extends CraftableFurnitureRecipe> getInnerRecipesForVariant(ResourceLocation identifier) {
        return Collections.singletonList(this.getInnerRecipes().get(0));
    }

    default public String getName(HolderLookup.Provider registryManager) {
        return this.getResultItem(registryManager).getHoverName().getString();
    }

    public static interface CraftableFurnitureRecipe
    extends Comparable<CraftableFurnitureRecipe> {
        public List<Ingredient> getIngredients();

        public ItemStack getResultItem(HolderLookup.Provider var1);

        public ItemStack craft(FurnitureRecipeInput var1, HolderLookup.Provider var2);

        public boolean matches(FurnitureRecipeInput var1, Level var2);

        public FurnitureRecipe parent();

        public ItemStack getRecipeOuput();

        @Override
        default public int compareTo(@NotNull CraftableFurnitureRecipe o) {
            return this.getRecipeOuput().toString().compareTo(o.getRecipeOuput().toString());
        }

        default public ItemStack craftAndRemoveItems(FurnitureRecipeInput input, HolderLookup.Provider registryManager) {
            ItemStack output = this.getResultItem(registryManager).copy();
            List<Ingredient> ingredients = this.getIngredients();
            Inventory playerInventory = input.playerInventory();
            block0: for (Ingredient ingredient : ingredients) {
                for (ItemStack stack : ingredient.getItems()) {
                    int indexOfStack = FurnitureRecipe.getSlotWithStackIgnoreNBT(playerInventory, stack);
                    int count = stack.getCount();
                    if (indexOfStack == -1) continue;
                    if (playerInventory.getItem(indexOfStack).getCount() >= stack.getCount()) {
                        ItemStack stack1 = playerInventory.getItem(indexOfStack);
                        stack1.shrink(stack.getCount());
                        playerInventory.setItem(indexOfStack, stack1);
                        playerInventory.setChanged();
                        continue block0;
                    }
                    int remainingCount = count - playerInventory.getItem(indexOfStack).getCount();
                    playerInventory.setItem(indexOfStack, ItemStack.EMPTY);
                    while (remainingCount > 0) {
                        indexOfStack = FurnitureRecipe.getSlotWithStackIgnoreNBT(playerInventory, stack);
                        if (indexOfStack != -1) {
                            ItemStack stack1 = playerInventory.getItem(indexOfStack);
                            if (stack1.getCount() >= remainingCount) {
                                stack1.shrink(remainingCount);
                                playerInventory.setItem(indexOfStack, stack1);
                                break;
                            }
                            int stackSize = stack1.getCount();
                            remainingCount = Math.max(remainingCount - stackSize, 0);
                            playerInventory.setItem(indexOfStack, ItemStack.EMPTY);
                            continue;
                        }
                        PaladinFurnitureMod.GENERAL_LOGGER.warn("Unable to craft recipe, this should never happen");
                        return ItemStack.EMPTY;
                    }
                    playerInventory.setChanged();
                }
            }
            return output;
        }
    }

    public record FurnitureRecipeInput(Inventory playerInventory) implements RecipeInput
    {
        public ItemStack getItem(int slot) {
            return this.playerInventory.getItem(slot);
        }

        public int size() {
            return this.playerInventory.getContainerSize();
        }

        public boolean isEmpty() {
            return this.playerInventory.isEmpty();
        }
    }
}

