/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class SimpleFurnitureRecipe
implements FurnitureRecipe,
FurnitureRecipe.CraftableFurnitureRecipe {
    final String group;
    final ItemStack output;
    final NonNullList<Ingredient> input;

    public SimpleFurnitureRecipe(String group, ItemStack output, List<Ingredient> input) {
        this.group = group;
        this.output = output;
        this.input = NonNullList.of((Object)Ingredient.EMPTY, (Object[])((Ingredient[])input.toArray(Ingredient[]::new)));
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.input;
    }

    @Override
    public boolean matches(FurnitureRecipe.FurnitureRecipeInput input, Level world) {
        NonNullList<Ingredient> ingredients = this.getIngredients();
        BitSet hasIngredients = new BitSet(ingredients.size());
        Inventory playerInventory = input.playerInventory();
        block0: for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            for (ItemStack stack : ingredient.getItems()) {
                if (playerInventory.countItem(stack.getItem()) < stack.getCount()) continue;
                hasIngredients.set(i);
                continue block0;
            }
        }
        return hasIngredients.cardinality() == ingredients.size();
    }

    @Override
    public FurnitureRecipe parent() {
        return this;
    }

    @Override
    public ItemStack getRecipeOuput() {
        return this.output;
    }

    @Override
    public ItemStack craft(FurnitureRecipe.FurnitureRecipeInput playerInventory, HolderLookup.Provider registryManager) {
        if (!this.output.getComponents().isEmpty() && this.output.has(DataComponents.BLOCK_ENTITY_DATA) && ((CustomData)this.output.get(DataComponents.BLOCK_ENTITY_DATA)).isEmpty()) {
            ItemStack stack = this.output.copy();
            stack.remove(DataComponents.BLOCK_ENTITY_DATA);
            return stack;
        }
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public String getGroup() {
        return this.group;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider registryManager) {
        return this.output;
    }

    public ItemStack getToastSymbol() {
        return PaladinFurnitureModBlocksItems.WORKING_TABLE.asItem().getDefaultInstance();
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipeTypes.SIMPLE_FURNITURE_SERIALIZER;
    }

    @Override
    public String outputClass() {
        return this.output.getItem().getClass().getSimpleName();
    }

    public boolean isSpecial() {
        return true;
    }

    @Override
    public List<FurnitureRecipe.CraftableFurnitureRecipe> getInnerRecipes() {
        return Collections.singletonList(this);
    }

    public static class Serializer
    implements RecipeSerializer<SimpleFurnitureRecipe> {
        private static final MapCodec<SimpleFurnitureRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(SimpleFurnitureRecipe::getGroup), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.output), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            Object[] ingredients2 = (Ingredient[])ingredients.stream().filter(ingredient -> !ingredient.isEmpty()).toArray(Ingredient[]::new);
            if (ingredients2.length == 0) {
                return DataResult.error(() -> "No ingredients for furniture recipe");
            }
            return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients2));
        }, DataResult::success).forGetter(SimpleFurnitureRecipe::getIngredients)).apply((Applicative)instance, SimpleFurnitureRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SimpleFurnitureRecipe> PACKET_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        public MapCodec<SimpleFurnitureRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SimpleFurnitureRecipe> streamCodec() {
            return PACKET_CODEC;
        }

        public static SimpleFurnitureRecipe read(RegistryFriendlyByteBuf packetByteBuf) {
            String string = packetByteBuf.readUtf();
            int i = packetByteBuf.readVarInt();
            NonNullList defaultedList = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            for (int j = 0; j < defaultedList.size(); ++j) {
                defaultedList.set(j, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)packetByteBuf)));
            }
            ItemStack itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)packetByteBuf);
            return new SimpleFurnitureRecipe(string, itemStack, (List<Ingredient>)defaultedList);
        }

        public static void write(RegistryFriendlyByteBuf packetByteBuf, SimpleFurnitureRecipe simpleFurnitureRecipe) {
            packetByteBuf.writeUtf(simpleFurnitureRecipe.group);
            packetByteBuf.writeVarInt(simpleFurnitureRecipe.input.size());
            for (Ingredient ingredient : simpleFurnitureRecipe.input) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)packetByteBuf, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)packetByteBuf, (Object)simpleFurnitureRecipe.output);
        }
    }
}

