/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.registry.dynamic;

import com.unlikepaladin.pfm.blocks.DyeableFurnitureBlock;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;

public class FurnitureEntry<T extends Block> {
    private final HashMap<VariantBase<?>, Set<T>> variantToBlockMapList = new LinkedHashMap();
    private final HashMap<VariantBase<?>, T> variantToBlockMap = new LinkedHashMap();
    private final HashMap<VariantBase<?>, T> variantToBlockMapNonBase = new LinkedHashMap();
    final List<T> allBlocks = new ArrayList<T>();
    private Class<T> type;

    public <J extends Block> void addBlock(VariantBase variantBase, J block1, boolean base) {
        J block;
        if (block1 != null) {
            block = block1;
            if (base) {
                this.variantToBlockMap.put(variantBase, block);
            } else {
                this.variantToBlockMapNonBase.put(variantBase, block);
            }
            if (!this.variantToBlockMapList.containsKey(variantBase)) {
                this.variantToBlockMapList.put(variantBase, new HashSet());
            }
        } else {
            throw new UnsupportedOperationException("Block was not instance of T");
        }
        this.variantToBlockMapList.get(variantBase).add(block);
        this.allBlocks.add(block);
        this.type = block1.getClass();
    }

    public Optional<Block> getEntryFromVariant(VariantBase<?> variant) {
        return this.getEntryFromVariant(variant, false);
    }

    public Optional<Block> getEntryFromVariantAndColor(VariantBase<?> variant, DyeColor color) {
        if (this.variantToBlockMapList.containsKey(variant)) {
            for (Block block : this.variantToBlockMapList.get(variant)) {
                DyeableFurnitureBlock dyeableFurnitureBlock;
                if (!(block instanceof DyeableFurnitureBlock) || (dyeableFurnitureBlock = (DyeableFurnitureBlock)block).getPFMColor() != color) continue;
                return Optional.of(block);
            }
        }
        return this.getEntryFromVariant(variant, false);
    }

    public List<ResourceLocation> getVariants() {
        return this.variantToBlockMap.keySet().stream().map(variantBase -> variantBase.identifier).toList();
    }

    public Optional<Block> getEntryFromVariant(VariantBase<?> variant, boolean stripped) {
        if (!stripped && this.variantToBlockMap.containsKey(variant)) {
            return Optional.of((Block)this.variantToBlockMap.get(variant));
        }
        if (this.variantToBlockMapNonBase.containsKey(variant)) {
            return Optional.of((Block)this.variantToBlockMapNonBase.get(variant));
        }
        return Optional.empty();
    }

    public VariantBase<?> getVariantFromEntry(Block block) {
        if (block.getClass() == this.getTClass()) {
            for (Map.Entry<VariantBase<?>, T> entry : this.variantToBlockMap.entrySet()) {
                if (!((Block)entry.getValue()).equals(block)) continue;
                return entry.getKey();
            }
            for (Map.Entry<VariantBase<?>, T> entry : this.variantToBlockMapNonBase.entrySet()) {
                if (!((Block)entry.getValue()).equals(block)) continue;
                return entry.getKey();
            }
            for (Map.Entry<VariantBase<?>, Object> entry : this.variantToBlockMapList.entrySet()) {
                if (!((Set)entry.getValue()).contains(block)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public void addBlock(T block) {
        if (block == null) {
            throw new UnsupportedOperationException("Block was not instance of T");
        }
        this.allBlocks.add(block);
    }

    public HashMap<VariantBase<?>, T> getVariantToBlockMap() {
        return this.variantToBlockMap;
    }

    public HashMap<VariantBase<?>, T> getVariantToBlockMapNonBase() {
        return this.variantToBlockMapNonBase;
    }

    public Optional<T> getFromIdentifier(ResourceLocation identifier, boolean base) {
        if (base) {
            for (VariantBase<?> variantBase : this.variantToBlockMap.keySet()) {
                if (!variantBase.identifier.equals((Object)identifier)) continue;
                return Optional.of((Block)this.variantToBlockMap.get(variantBase));
            }
        } else {
            for (VariantBase<?> variantBase : this.variantToBlockMapNonBase.keySet()) {
                if (!variantBase.identifier.equals((Object)identifier)) continue;
                return Optional.of((Block)this.variantToBlockMapNonBase.get(variantBase));
            }
        }
        for (Block block : this.allBlocks) {
            if (!block.getDescriptionId().contains(identifier.getPath())) continue;
            return Optional.of(block);
        }
        return Optional.empty();
    }

    public T getFromVanillaWoodType(Boat.Type woodType, boolean base) {
        if (base) {
            for (VariantBase<?> variant : this.variantToBlockMap.keySet()) {
                if (!variant.getBaseBlock().equals(woodType.getPlanks())) continue;
                return (T)((Block)this.variantToBlockMap.get(variant));
            }
        } else {
            for (VariantBase<?> variant : this.variantToBlockMapNonBase.keySet()) {
                if (!variant.getBaseBlock().equals(woodType.getPlanks())) continue;
                return (T)((Block)this.variantToBlockMapNonBase.get(variant));
            }
        }
        return null;
    }

    public HashMap<VariantBase<?>, Set<T>> getVariantToBlockMapList() {
        return this.variantToBlockMapList;
    }

    public List<T> getAllBlocks() {
        return this.allBlocks;
    }

    public Class<T> getTClass() {
        return this.type;
    }
}

