/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.registry.neoforge;

import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class BlockItemRegistryImpl {
    public static Map<String, Supplier<Item>> items = new LinkedHashMap<String, Supplier<Item>>();
    public static Map<String, Block> blocks = new HashMap<String, Block>();
    public static Map<String, Tuple<String, CreativeModeTab>> itemNameToGroup = new HashMap<String, Tuple<String, CreativeModeTab>>();

    public static void registerItemPlatformSpecific(String itemId, Supplier<Item> item, Tuple<String, CreativeModeTab> group) {
        items.put(itemId, item);
        itemNameToGroup.put(itemId, group);
    }

    public static void registerBlockPlatformSpecific(String blockId, Block block, boolean registerItem) {
        if (registerItem) {
            PaladinFurnitureModBlocksItems.BLOCKS.add(block);
            BlockItemRegistryImpl.registerBlockItemPlatformSpecific(blockId, block, (Tuple<String, CreativeModeTab>)new Tuple((Object)"building_blocks", (Object)((CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.BUILDING_BLOCKS))));
        }
        blocks.put(blockId, block);
    }

    public static void registerBlockItemPlatformSpecific(String itemName, Block block, Tuple<String, CreativeModeTab> group) {
        if (AbstractSittableBlock.isWoodBased(block.defaultBlockState())) {
            BlockItemRegistryImpl.registerItemPlatformSpecific(itemName, () -> new BlockItem(block, new Item.Properties()){

                public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                    return 300;
                }
            }, group);
        }
        BlockItemRegistryImpl.registerItemPlatformSpecific(itemName, () -> new BlockItem(block, new Item.Properties()), group);
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }
}

