/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.registry.neoforge;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.compat.cookingforblockheads.neoforge.PFMCookingForBlockHeadsCompat;
import com.unlikepaladin.pfm.menus.StoveScreenHandler;
import com.unlikepaladin.pfm.registry.TriFunc;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;

public class ScreenHandlerRegistryImpl {
    public static final Map<ResourceLocation, MenuType<?>> screenHandlerMap = new LinkedHashMap();

    public static <T extends AbstractContainerMenu> MenuType<T> registerScreenHandlerExtended(ResourceLocation id, TriFunc<Integer, Inventory, FriendlyByteBuf, T> factory) {
        MenuType type = IMenuTypeExtension.create(factory::apply);
        screenHandlerMap.put(id, type);
        return type;
    }

    public static <T extends AbstractContainerMenu> MenuType<T> registerScreenHandlerSimple(ResourceLocation id, BiFunction<Integer, Inventory, T> factory) {
        MenuType type = new MenuType(factory::apply, FeatureFlags.DEFAULT_FLAGS);
        screenHandlerMap.put(id, type);
        return type;
    }

    public static <T extends AbstractContainerMenu, D> MenuType<T> registerScreenHandlerExtended(ResourceLocation id, TriFunc<Integer, Inventory, D, T> factory, StreamCodec<RegistryFriendlyByteBuf, D> pac) {
        if (pac == null) {
            MenuType type = new MenuType((syncId, playerInventory) -> (AbstractContainerMenu)factory.apply(syncId, playerInventory, null), FeatureFlags.DEFAULT_FLAGS);
            screenHandlerMap.put(id, type);
            return type;
        }
        MenuType type = IMenuTypeExtension.create((syncId, inventory, buf) -> (AbstractContainerMenu)factory.apply(syncId, inventory, pac.decode((Object)buf)));
        screenHandlerMap.put(id, type);
        return type;
    }

    public static <T extends AbstractContainerMenu> Tuple<TriFunc<Integer, Inventory, StoveScreenHandler.StoveData, T>, StreamCodec<RegistryFriendlyByteBuf, StoveScreenHandler.StoveData>> getStoveMenuFactory() {
        if (PaladinFurnitureMod.getModList().contains("cookingforblockheads")) {
            return new Tuple(PFMCookingForBlockHeadsCompat.getStoveScreenHandler(), PFMCookingForBlockHeadsCompat.getStovePacket());
        }
        return new Tuple((integer, playerInventory, data) -> new StoveScreenHandler((int)integer, (Inventory)playerInventory, (StoveScreenHandler.StoveData)data), StoveScreenHandler.PACKET_CODEC);
    }
}

