/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.runtime;

import com.google.common.base.Stopwatch;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.data.materials.StoneVariantRegistry;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.runtime.ClientOverlaySetter;
import com.unlikepaladin.pfm.runtime.PFMGenerator;
import com.unlikepaladin.pfm.runtime.PFMProvider;
import com.unlikepaladin.pfm.runtime.PFMRuntimeResources;
import com.unlikepaladin.pfm.runtime.assets.PFMBlockstateModelProvider;
import com.unlikepaladin.pfm.runtime.assets.PFMLangProvider;
import com.unlikepaladin.pfm.runtime.data.PFMMCMetaProvider;
import com.unlikepaladin.pfm.utilities.PFMFileUtil;
import com.unlikepaladin.pfm.utilities.Version;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.minecraft.SharedConstants;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import org.apache.logging.log4j.LogManager;

public class PFMAssetGenerator
extends PFMGenerator {
    public static boolean FROZEN = false;

    public PFMAssetGenerator(Path output, boolean logOrDebug) {
        super(output, logOrDebug, LogManager.getLogger((String)"PFM-Asset-Generation"));
    }

    @Override
    public void run() throws IOException {
        if (!FROZEN) {
            PFMAssetGenerator.setAssetsRunning(true);
            this.log("Packs:");
            for (PackResources pack : PFMRuntimeResources.RESOURCE_PACK_LIST) {
                this.log("\tPack {}", pack.location().title().getString());
                for (String namespace : pack.getNamespaces(PackType.CLIENT_RESOURCES)) {
                    this.log("\t\tNamespace {}", namespace);
                }
            }
            FROZEN = true;
            Path pfmCacheDataFile = this.output.resolve("pfmCacheData.json");
            if (!pfmCacheDataFile.toFile().isFile()) {
                Files.deleteIfExists(pfmCacheDataFile);
                Files.createFile(pfmCacheDataFile, new FileAttribute[0]);
                Files.writeString(pfmCacheDataFile, (CharSequence)"{}", new OpenOption[0]);
            }
            PFMGenerator.PFMCache cached = PFMGenerator.PFMCache.fromJson(JSON_PARSER.parse(Files.readString(pfmCacheDataFile)));
            List<String> hashToCompare = this.hashDirectory(this.output.toFile(), false);
            ArrayList<ResourceLocation> variants = new ArrayList<ResourceLocation>();
            WoodVariantRegistry.getVariants().stream().sorted().forEach(woodVariant -> variants.add(woodVariant.identifier));
            StoneVariantRegistry.getVariants().stream().sorted().forEach(stoneVariant -> variants.add(stoneVariant.identifier));
            PFMGenerator.PFMCache current = new PFMGenerator.PFMCache(SharedConstants.getCurrentVersion().getName(), Version.getCurrentVersion(), PFMFileUtil.getModLoader(), hashToCompare, variants);
            if (!cached.equals(current)) {
                ArrayList<PFMProvider> providers = new ArrayList<PFMProvider>();
                this.getLogger().info("Starting PFM Asset Generation");
                PFMFileUtil.deleteDir(this.output.toFile());
                PFMRuntimeResources.createDirIfNeeded(this.output);
                Stopwatch stopwatch = Stopwatch.createStarted();
                PFMMCMetaProvider metaProvider = new PFMMCMetaProvider(this);
                metaProvider.setInfo(new PFMMCMetaProvider.PackInfo(PackType.CLIENT_RESOURCES, "PFM-Assets"));
                providers.add(metaProvider);
                providers.add(new PFMBlockstateModelProvider(this));
                providers.add(new PFMLangProvider(this));
                this.setTotalCount(providers.size());
                if (PaladinFurnitureMod.isClient && !PaladinFurnitureMod.getPFMConfig().disableGeneratingScreen()) {
                    ClientOverlaySetter.setOverlayToPFMOverlay(this);
                }
                boolean allDone = false;
                ExecutorService executor = Executors.newFixedThreadPool(providers.size());
                List<Future> futures = providers.stream().map(provider -> executor.submit(provider::run)).toList();
                while (!allDone) {
                    allDone = futures.stream().allMatch(Future::isDone);
                    int completedTasks = (int)futures.stream().filter(Future::isDone).count();
                    this.setCount(completedTasks);
                    if (!PaladinFurnitureMod.isClient) continue;
                    ClientOverlaySetter.updateScreen();
                }
                executor.shutdown();
                for (Future future : futures) {
                    try {
                        future.get();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.error("Provider was interrupted: " + e.getMessage());
                    }
                    catch (ExecutionException e) {
                        this.error("Provider failed with exception: " + String.valueOf(e.getCause()));
                        e.getCause().printStackTrace();
                    }
                }
                this.getLogger().info("Asset providers took: {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
                this.createPackIcon();
                Files.deleteIfExists(pfmCacheDataFile);
                Files.createFile(pfmCacheDataFile, new FileAttribute[0]);
                List<String> newDataHash = this.hashDirectory(this.output.toFile(), false);
                PFMGenerator.PFMCache cache = new PFMGenerator.PFMCache(SharedConstants.getCurrentVersion().getName(), Version.getCurrentVersion(), PFMFileUtil.getModLoader(), newDataHash, variants);
                Files.writeString(pfmCacheDataFile, (CharSequence)GSON.toJson(cache.toJson()), StandardOpenOption.APPEND);
            } else {
                this.getLogger().info("Data Hash for Assets and Variant List matched, skipping generation");
            }
            PFMAssetGenerator.setAssetsRunning(false);
        }
    }
}

