/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.runtime.data;

import com.unlikepaladin.pfm.runtime.PFMGenerator;
import com.unlikepaladin.pfm.runtime.PFMProvider;
import com.unlikepaladin.pfm.runtime.PFMRuntimeResources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import net.minecraft.SharedConstants;
import net.minecraft.server.packs.PackType;
import org.apache.commons.io.IOUtils;

public class PFMMCMetaProvider
extends PFMProvider {
    private PackInfo info;

    public PFMMCMetaProvider(PFMGenerator parent) {
        super(parent, "PFM MC Meta");
        parent.setProgress("Generating Minecraft Metadata");
    }

    public void setInfo(PackInfo info) {
        this.info = info;
    }

    @Override
    public void run() {
        this.startProviderRun();
        try (BufferedWriter writer = IOUtils.buffer((Writer)new FileWriter(new File(PFMRuntimeResources.createDirIfNeeded(this.getParent().getOutput()).toFile(), "pack.mcmeta")));){
            writer.write("{\n");
            writer.write("  \"pack\":\n   {\n");
            writer.write("          \"pack_format\": ");
            writer.write(String.valueOf(SharedConstants.getCurrentVersion().getPackVersion(this.info.type)));
            writer.write(",\n           \"description\" : \"" + this.info.description + "\"\n  }\n");
            writer.write("}");
        }
        catch (IOException e) {
            this.getParent().getLogger().error("Writer exception: " + String.valueOf(e));
            e.printStackTrace();
        }
        this.endProviderRun();
    }

    public record PackInfo(PackType type, String description) {
    }
}

