/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.runtime.data;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.ArmChairBlock;
import com.unlikepaladin.pfm.blocks.ArmChairColoredBlock;
import com.unlikepaladin.pfm.blocks.BasicChairBlock;
import com.unlikepaladin.pfm.blocks.BasicCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.BasicDeskBlock;
import com.unlikepaladin.pfm.blocks.BasicDeskCabinetBlock;
import com.unlikepaladin.pfm.blocks.BasicLampBlock;
import com.unlikepaladin.pfm.blocks.BasicTableBlock;
import com.unlikepaladin.pfm.blocks.BasicToiletBlock;
import com.unlikepaladin.pfm.blocks.ClassicBedBlock;
import com.unlikepaladin.pfm.blocks.ClassicChairBlock;
import com.unlikepaladin.pfm.blocks.ClassicChairDyeableBlock;
import com.unlikepaladin.pfm.blocks.ClassicCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.ClassicNightstandBlock;
import com.unlikepaladin.pfm.blocks.ClassicStoolBlock;
import com.unlikepaladin.pfm.blocks.ClassicTableBlock;
import com.unlikepaladin.pfm.blocks.CutleryBlock;
import com.unlikepaladin.pfm.blocks.DinnerChairBlock;
import com.unlikepaladin.pfm.blocks.DinnerTableBlock;
import com.unlikepaladin.pfm.blocks.FreezerBlock;
import com.unlikepaladin.pfm.blocks.FridgeBlock;
import com.unlikepaladin.pfm.blocks.FroggyChairBlock;
import com.unlikepaladin.pfm.blocks.HerringbonePlankBlock;
import com.unlikepaladin.pfm.blocks.IronStoveBlock;
import com.unlikepaladin.pfm.blocks.KitchenCabinetBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterOvenBlock;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.KitchenRangeHoodBlock;
import com.unlikepaladin.pfm.blocks.KitchenSinkBlock;
import com.unlikepaladin.pfm.blocks.KitchenStovetopBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallCounterBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallDrawerBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallDrawerSmallBlock;
import com.unlikepaladin.pfm.blocks.LogStoolBlock;
import com.unlikepaladin.pfm.blocks.LogTableBlock;
import com.unlikepaladin.pfm.blocks.MicrowaveBlock;
import com.unlikepaladin.pfm.blocks.MirrorBlock;
import com.unlikepaladin.pfm.blocks.ModernChairBlock;
import com.unlikepaladin.pfm.blocks.ModernCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.ModernDinnerTableBlock;
import com.unlikepaladin.pfm.blocks.ModernStoolBlock;
import com.unlikepaladin.pfm.blocks.PendantBlock;
import com.unlikepaladin.pfm.blocks.PlateBlock;
import com.unlikepaladin.pfm.blocks.RawLogTableBlock;
import com.unlikepaladin.pfm.blocks.ShowerTowelBlock;
import com.unlikepaladin.pfm.blocks.SimpleBedBlock;
import com.unlikepaladin.pfm.blocks.SimpleBunkLadderBlock;
import com.unlikepaladin.pfm.blocks.SimpleSofaBlock;
import com.unlikepaladin.pfm.blocks.SimpleStoolBlock;
import com.unlikepaladin.pfm.blocks.StoveBlock;
import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.items.PFMComponents;
import com.unlikepaladin.pfm.menus.WorkbenchScreenHandler;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.runtime.PFMGenerator;
import com.unlikepaladin.pfm.runtime.PFMProvider;
import com.unlikepaladin.pfm.runtime.data.DynamicFurnitureRecipeJsonFactory;
import com.unlikepaladin.pfm.runtime.data.SimpleFurnitureRecipeJsonFactory;
import com.unlikepaladin.pfm.runtime.data.neoforge.PFMRecipeProviderImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class PFMRecipeProvider
extends PFMProvider {
    public PFMRecipeProvider(PFMGenerator parent) {
        super(parent, "PFM Recipes");
        parent.setProgress("Generating Recipes");
    }

    private static HolderLookup.Provider createWrapperLookup() {
        RegistrySetBuilder builder = new RegistrySetBuilder();
        return builder.build((RegistryAccess)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY));
    }

    @Override
    public void run() {
        this.startProviderRun();
        this.createWriter();
        final Path path = this.getParent().getOutput();
        final HashSet set = Sets.newHashSet();
        WorkbenchScreenHandler.ALL_RECIPES.clear();
        final HolderLookup.Provider lookup = PFMRecipeProvider.createWrapperLookup();
        this.generateRecipes(new RecipeOutput(){

            public void accept(ResourceLocation recipeId, Recipe<?> recipe, @Nullable AdvancementHolder advancementEntry) {
                if (!set.add(recipeId)) {
                    PFMRecipeProvider.this.getParent().getLogger().error("Duplicate recipe " + String.valueOf(recipeId));
                    throw new IllegalStateException("Duplicate recipe " + String.valueOf(recipeId));
                }
                if (recipe == null) {
                    PFMRecipeProvider.this.getParent().getLogger().error("Recipe Json Provider is null");
                    throw new IllegalStateException("Recipe Json Provider is null");
                }
                RegistryOps ops = lookup.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
                Path recipePath = path.resolve("data/" + recipeId.getNamespace() + "/recipe/" + recipeId.getPath() + ".json");
                PFMRecipeProvider.this.enqueueJsonWrite((BlockingQueue<Map.Entry<Path, String>>)PFMRecipeProvider.this.getWriteQueue(), recipePath, (JsonElement)Recipe.CODEC.encodeStart((DynamicOps)ops, recipe).getOrThrow(IllegalStateException::new));
                if (advancementEntry != null) {
                    Path advancementPath = path.resolve("data/" + recipeId.getNamespace() + "/advancement/" + advancementEntry.id().getPath() + ".json");
                    PFMRecipeProvider.this.enqueueJsonWrite((BlockingQueue<Map.Entry<Path, String>>)PFMRecipeProvider.this.getWriteQueue(), advancementPath, (JsonElement)Advancement.CODEC.encodeStart((DynamicOps)ops, (Object)advancementEntry.value()).getOrThrow(IllegalStateException::new));
                }
            }

            public Advancement.Builder advancement() {
                return Advancement.Builder.recipeAdvancement().parent(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT);
            }
        });
        this.enqueueJsonWrite(this.getWriteQueue(), path.resolve("data/pfm/advancements/recipes/root.json"), (JsonElement)Advancement.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)Advancement.Builder.advancement().addCriterion("has_planks", PFMRecipeProvider.conditionsFromTag((TagKey<Item>)ItemTags.PLANKS)).build(ResourceLocation.parse((String)"root")).value()).getOrThrow(IllegalAccessError::new));
        this.waitForWrite();
        this.endProviderRun();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    protected static ResourceLocation getId(Block block) {
        return PFMRecipeProviderImpl.getId(block);
    }

    protected void generateRecipes(RecipeOutput exporter) {
        FurnitureBlock[] mirrors;
        FurnitureBlock[] showerTowels;
        FurnitureBlock[] basicToilets;
        FurnitureBlock[] cutleries;
        FurnitureBlock[] plates;
        KitchenStovetopBlock[] stovetopBlocks;
        FurnitureBlock[] ironStove;
        FurnitureBlock[] stoves;
        FurnitureBlock[] rangeHoods;
        FurnitureBlock[] microwaves;
        FurnitureBlock[] freezers;
        FurnitureBlock[] fridges;
        FurnitureBlock[] herringbonePlanks;
        FurnitureBlock[] simpleSofas;
        FurnitureBlock[] armChairs;
        FurnitureBlock[] woolClassicChairs;
        FurnitureBlock[] froggyChairs;
        ArrayList<ResourceLocation> generatedRecipes = new ArrayList<ResourceLocation>();
        PFMRecipeProvider.offerBasicChairRecipe(BasicChairBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(BasicChairBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerDinnerChairRecipe(DinnerChairBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(DinnerChairBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerClassicChairRecipe(ClassicChairBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(ClassicChairBlock.class).getVariants(), exporter);
        for (FurnitureBlock froggyChair : froggyChairs = FroggyChairBlock.streamFroggyChair().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(froggyChair.getBlock()))) continue;
            PFMRecipeProvider.offerFroggyChairRecipe((ItemLike)froggyChair.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{froggyChair.getFroggyChairMaterial().asItem()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(froggyChair.getBlock()));
        }
        for (FurnitureBlock classicChair : woolClassicChairs = ClassicChairDyeableBlock.streamWoodDyeableChair().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(classicChair.getBlock()))) continue;
            PFMRecipeProvider.offerClassicChairDyedRecipe((ItemLike)classicChair.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{Items.OAK_LOG}), Ingredient.of((ItemLike[])new ItemLike[]{classicChair.getArmChairMaterial()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(classicChair.getBlock()));
        }
        PFMRecipeProvider.offerModernChairRecipe(ModernChairBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(ModernChairBlock.class).getVariants(), exporter);
        for (FurnitureBlock armChair : armChairs = ArmChairColoredBlock.streamArmChairColored().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(armChair.getBlock()))) continue;
            PFMRecipeProvider.offerArmChairRecipe((ItemLike)armChair.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{Items.OAK_LOG}), Ingredient.of((ItemLike[])new ItemLike[]{armChair.getArmChairMaterial().asItem()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(armChair.getBlock()));
        }
        for (FurnitureBlock sofa : simpleSofas = SimpleSofaBlock.streamSimpleSofas().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(sofa.getBlock()))) continue;
            PFMRecipeProvider.offerSimpleSofaRecipe((ItemLike)sofa.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{Items.OAK_LOG}), Ingredient.of((ItemLike[])new ItemLike[]{sofa.getArmChairMaterial().asItem()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(sofa.getBlock()));
        }
        FurnitureBlock[] leatherArmChairs = ArmChairBlock.streamArmChairs().toList().toArray(new FurnitureBlock[0]);
        for (FurnitureBlock armChair : leatherArmChairs) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(armChair.getBlock()))) continue;
            PFMRecipeProvider.offerArmChairRecipe((ItemLike)armChair.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{Items.OAK_LOG}), Ingredient.of((ItemLike[])new ItemLike[]{armChair.getArmChairMaterial().asItem()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(armChair.getBlock()));
        }
        PFMRecipeProvider.offerBasicTableRecipe(BasicTableBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(BasicTableBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerClassicTableRecipe(ClassicTableBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(ClassicTableBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerLogTableRecipe(LogTableBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(LogTableBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerLogTableRecipe(RawLogTableBlock.class, "secondary", "secondary", PaladinFurnitureMod.furnitureEntryMap.get(RawLogTableBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerDinnerTableRecipe(DinnerTableBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(DinnerTableBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerModernDinnerTableRecipe(ModernDinnerTableBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(ModernDinnerTableBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerClassicNightStandRecipe(ClassicNightstandBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(ClassicNightstandBlock.class).getVariants(), exporter);
        for (Block block2 : this.getVanillaBeds()) {
            PFMRecipeProvider.offerSimpleBedRecipe(SimpleBedBlock.class, "base", PaladinFurnitureMod.furnitureEntryMap.get(SimpleBedBlock.class).getVariants(), Ingredient.of((ItemLike[])new ItemLike[]{block2}), exporter);
            PFMRecipeProvider.offerClassicBedRecipe(ClassicBedBlock.class, "base", PaladinFurnitureMod.furnitureEntryMap.get(ClassicBedBlock.class).getVariants(), Ingredient.of((ItemLike[])new ItemLike[]{block2}), "fence", exporter);
        }
        PFMRecipeProvider.offerSimpleBunkLadderRecipe(SimpleBunkLadderBlock.class, "base", PaladinFurnitureMod.furnitureEntryMap.get(SimpleBunkLadderBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerLogStoolRecipe(LogStoolBlock.class, "secondary", PaladinFurnitureMod.furnitureEntryMap.get(LogStoolBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerSimpleStoolRecipe(SimpleStoolBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(SimpleStoolBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerClassicStoolRecipe(ClassicStoolBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(ClassicStoolBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerModernStoolRecipe(ModernStoolBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(ModernStoolBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerCounterRecipe(KitchenCounterBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerKitchenSinkRecipe(KitchenSinkBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(KitchenSinkBlock.class).getVariants(), Ingredient.of((ItemLike[])new ItemLike[]{Items.BUCKET}), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}), exporter);
        PFMRecipeProvider.offerCounterApplianceRecipe(KitchenDrawerBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(KitchenDrawerBlock.class).getVariants(), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHEST}), exporter);
        PFMRecipeProvider.offerCounterApplianceRecipe(KitchenCounterOvenBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterOvenBlock.class).getVariants(), Ingredient.of((ItemLike[])new ItemLike[]{Items.FURNACE}), exporter);
        PFMRecipeProvider.offerCounterRecipe(KitchenWallCounterBlock.class, "base", "base", PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallCounterBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerWallDrawerRecipe(KitchenWallDrawerBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerBlock.class).getVariants(), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHEST}), exporter);
        PFMRecipeProvider.offerWallDrawerSmallRecipe(KitchenWallDrawerSmallBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerSmallBlock.class).getVariants(), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHEST}), exporter);
        PFMRecipeProvider.offerCabinetRecipe(KitchenCabinetBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(KitchenCabinetBlock.class).getVariants(), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHEST}), exporter);
        for (FurnitureBlock herringbonePlank : herringbonePlanks = HerringbonePlankBlock.streamPlanks().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(herringbonePlank.getBlock()))) continue;
            PFMRecipeProvider.offerHerringbonePlanks((ItemLike)herringbonePlank.getBlock(), herringbonePlank.getSlab().asItem(), exporter);
        }
        for (FurnitureBlock fridge : fridges = FridgeBlock.streamFridges().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(fridge.getBlock()))) continue;
            PFMRecipeProvider.offerFridgeRecipe((ItemLike)fridge.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{fridge.getFridgeMaterial().asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHEST}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(fridge.getBlock()));
        }
        for (FurnitureBlock freezer : freezers = FreezerBlock.streamFreezers().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(freezer.getBlock()))) continue;
            PFMRecipeProvider.offerFreezerRecipe((ItemLike)freezer.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{freezer.getFridgeMaterial().asItem()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(freezer.getBlock()));
        }
        for (FurnitureBlock microwave : microwaves = MicrowaveBlock.streamMicrowaves().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(microwave.getBlock()))) continue;
            PFMRecipeProvider.offerMicrowaveRecipe((ItemLike)microwave.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{microwave.getFridgeMaterial().asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.FURNACE}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(microwave.getBlock()));
        }
        for (FurnitureBlock rangeHood : rangeHoods = KitchenRangeHoodBlock.streamOvenRangeHoods().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(rangeHood.getBlock()))) continue;
            PFMRecipeProvider.offerRangeHoodRecipe((ItemLike)rangeHood.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{rangeHood.getFridgeMaterial().asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE_LAMP}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(rangeHood.getBlock()));
        }
        for (FurnitureBlock stove : stoves = StoveBlock.streamStoves().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(stove.getBlock()))) continue;
            PFMRecipeProvider.offerStoveRecipe((ItemLike)stove.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{stove.getFridgeMaterial().asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.FURNACE}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(stove.getBlock()));
        }
        for (FurnitureBlock stove : ironStove = IronStoveBlock.streamIronStoves().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(stove.getBlock()))) continue;
            PFMRecipeProvider.offerStoveRecipe((ItemLike)stove.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{stove.getFridgeMaterial().asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.FURNACE}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(stove.getBlock()));
        }
        for (KitchenStovetopBlock stove : stovetopBlocks = KitchenStovetopBlock.streamKitchenStovetop().toList().toArray(new KitchenStovetopBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId((Block)stove))) continue;
            PFMRecipeProvider.offerStovetopRecipe((ItemLike)stove, Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.GRAY_CONCRETE}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId((Block)stove));
        }
        for (FurnitureBlock plate : plates = PlateBlock.streamPlates().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(plate.getBlock()))) continue;
            PFMRecipeProvider.offerPlateRecipe((ItemLike)plate.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{plate.getPlateMaterial()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ITEM_FRAME}), Ingredient.of((ItemLike[])new ItemLike[]{plate.getPlateDecoration()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(plate.getBlock()));
        }
        for (FurnitureBlock cutlery : cutleries = CutleryBlock.streamCutlery().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(cutlery.getBlock()))) continue;
            PFMRecipeProvider.offerCutleryRecipe((ItemLike)cutlery.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{cutlery.getCutleryMaterial()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(cutlery.getBlock()));
        }
        PaladinFurnitureMod.furnitureEntryMap.get(PendantBlock.class).getAllBlocks().forEach(block -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                Block hang = Blocks.LIGHT_GRAY_CONCRETE;
                Block base = block == PaladinFurnitureModBlocksItems.GLASS_MODERN_PENDANT ? Blocks.WHITE_STAINED_GLASS : (block == PaladinFurnitureModBlocksItems.WHITE_MODERN_PENDANT ? Blocks.WHITE_CONCRETE : Blocks.GRAY_CONCRETE);
                PFMRecipeProvider.offerPendantRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{base}), Ingredient.of((ItemLike[])new ItemLike[]{hang}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        if (!generatedRecipes.contains(BuiltInRegistries.ITEM.getKey((Object)PaladinFurnitureModBlocksItems.LIGHT_SWITCH_ITEM))) {
            SimpleFurnitureRecipeJsonFactory.create(PaladinFurnitureModBlocksItems.LIGHT_SWITCH_ITEM.getDefaultInstance().copyWithCount(6)).input((ItemLike)Blocks.WHITE_CONCRETE, 6).input((ItemLike)Blocks.LIGHT_GRAY_CONCRETE, 2).input((ItemLike)Items.REDSTONE).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)PaladinFurnitureModBlocksItems.LIGHT_SWITCH_ITEM.getDescriptionId().replace("block.pfm.", "")));
            generatedRecipes.add(BuiltInRegistries.ITEM.getKey((Object)PaladinFurnitureModBlocksItems.LIGHT_SWITCH_ITEM));
        }
        for (FurnitureBlock toilet : basicToilets = BasicToiletBlock.streamBasicToilet().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(toilet.getBlock()))) continue;
            PFMRecipeProvider.offerToiletRecipe((ItemLike)toilet.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE_BUTTON}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.QUARTZ_BLOCK}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(toilet.getBlock()));
        }
        if (!generatedRecipes.contains(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.WALL_TOILET_PAPER))) {
            PFMRecipeProvider.offerWallToiletPaperRecipe((ItemLike)PaladinFurnitureModBlocksItems.WALL_TOILET_PAPER, Ingredient.of((ItemLike[])new ItemLike[]{Blocks.STONE}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.WALL_TOILET_PAPER));
        }
        if (!generatedRecipes.contains(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.BASIC_SINK))) {
            PFMRecipeProvider.offerSinkRecipe((ItemLike)PaladinFurnitureModBlocksItems.BASIC_SINK, Ingredient.of((ItemLike[])new ItemLike[]{Blocks.QUARTZ_BLOCK}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.BASIC_SINK));
        }
        if (!generatedRecipes.contains(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.BASIC_BATHTUB))) {
            PFMRecipeProvider.offerBathtubRecipe((ItemLike)PaladinFurnitureModBlocksItems.BASIC_BATHTUB, Ingredient.of((ItemLike[])new ItemLike[]{Blocks.QUARTZ_BLOCK}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.BASIC_BATHTUB));
        }
        if (!generatedRecipes.contains(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.BASIC_SHOWER_HEAD))) {
            PFMRecipeProvider.offerShowerHeadRecipe((ItemLike)PaladinFurnitureModBlocksItems.BASIC_SHOWER_HEAD, Ingredient.of((ItemLike[])new ItemLike[]{Items.WATER_BUCKET}), exporter);
            PFMRecipeProvider.offerShowerHandleRecipe(PaladinFurnitureModBlocksItems.BASIC_SHOWER_HANDLE_ITEM.getDefaultInstance(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.LEVER}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.BASIC_SHOWER_HEAD));
            generatedRecipes.add(BuiltInRegistries.ITEM.getKey((Object)PaladinFurnitureModBlocksItems.BASIC_SHOWER_HANDLE_ITEM));
        }
        if (!generatedRecipes.contains(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.MESH_TRASHCAN))) {
            SimpleFurnitureRecipeJsonFactory.create((ItemLike)PaladinFurnitureModBlocksItems.MESH_TRASHCAN, 1).input((ItemLike)Items.IRON_INGOT, 1).input((ItemLike)Items.ENDER_PEARL, 1).input((ItemLike)Blocks.IRON_BARS, 4).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)PaladinFurnitureModBlocksItems.MESH_TRASHCAN.asItem().getDescriptionId().replace("block.pfm.", "")));
            generatedRecipes.add(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.MESH_TRASHCAN));
        }
        if (!generatedRecipes.contains(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.TRASHCAN))) {
            SimpleFurnitureRecipeJsonFactory.create((ItemLike)PaladinFurnitureModBlocksItems.TRASHCAN, 1).input((ItemLike)Items.IRON_INGOT, 1).input((ItemLike)Items.ENDER_PEARL, 1).input((ItemLike)Blocks.IRON_BARS, 4).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)PaladinFurnitureModBlocksItems.TRASHCAN.asItem().getDescriptionId().replace("block.pfm.", "")));
            generatedRecipes.add(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.TRASHCAN));
        }
        for (FurnitureBlock towel : showerTowels = ShowerTowelBlock.streamShowerTowels().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(towel.getBlock()))) continue;
            PFMRecipeProvider.offerShowerTowelRecipe((ItemLike)towel.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{towel.getWoolColor()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(towel.getBlock()));
        }
        for (FurnitureBlock mirror : mirrors = MirrorBlock.streamMirrorBlocks().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(mirror.getBlock()))) continue;
            PFMRecipeProvider.offerMirrorRecipe((ItemLike)mirror.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{mirror.getBaseMaterial()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(mirror.getBlock()));
        }
        PFMRecipeProvider.offerLampRecipes(exporter);
        PFMRecipeProvider.offerBasicCoffeeTableRecipe(BasicCoffeeTableBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(BasicCoffeeTableBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerModernCoffeeTableRecipe(ModernCoffeeTableBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(ModernCoffeeTableBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerClassicCoffeeTableRecipe(ClassicCoffeeTableBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(ClassicCoffeeTableBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerBasicDeskRecipe(BasicDeskBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(BasicDeskBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerBasicDeskCabinetRecipe(BasicDeskCabinetBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(BasicDeskCabinetBlock.class).getVariants(), exporter);
        PaladinFurnitureMod.pfmModCompatibilities.forEach(pfmModCompatibility -> pfmModCompatibility.generateRecipes(exporter));
    }

    public static void offerLampRecipes(RecipeOutput exporter) {
        for (DyeColor color : DyeColor.values()) {
            DataComponentPatch.Builder builder = DataComponentPatch.builder();
            builder.set(PFMComponents.COLOR_COMPONENT, (Object)color);
            DynamicFurnitureRecipeJsonFactory.create(BasicLampBlock.class, 1, WoodVariantRegistry.getVariants().stream().map(woodVariant -> woodVariant.identifier).toList(), builder.build()).vanillaInput((ItemLike)ModelHelper.getWoolColor(color.getSerializedName()), 3).vanillaInput((ItemLike)Items.TORCH).vanillaInput((ItemLike)Items.REDSTONE).childInput("stripped_log", 2).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)String.format("basic_%s_lamp", color.getSerializedName())));
        }
    }

    public static Tuple<Block, Block> getCounterMaterials(VariantBase<?> variantBase) {
        Block counterTop = variantBase.getSecondaryBlock();
        Block counterBase = variantBase.getBaseBlock();
        if (variantBase.identifier.getPath().equals("calcite") || variantBase.identifier.getPath().equals("netherite")) {
            Block temp = counterBase;
            counterBase = counterTop;
            counterTop = temp;
        }
        return new Tuple((Object)counterBase, (Object)counterTop);
    }

    public Block getVanillaBed(Block block) {
        if (block instanceof SimpleBedBlock) {
            String color = ((SimpleBedBlock)block).getPFMColor().getName();
            return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)("minecraft:" + color + "_bed")));
        }
        return null;
    }

    public List<Block> getVanillaBeds() {
        ArrayList<Block> beds = new ArrayList<Block>();
        BuiltInRegistries.BLOCK.stream().forEach(block -> {
            if (block instanceof BedBlock && BuiltInRegistries.BLOCK.getKey(block).getNamespace().equals("minecraft")) {
                beds.add((Block)block);
            }
        });
        return beds;
    }

    public static void offerBasicChairRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("chairs").childInput(legMaterial, 2).childInput(baseMaterial, 4).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerFroggyChairRecipe(ItemLike output, Ingredient baseMaterial, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 4).group("chairs").criterion("has_concrete", PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(baseMaterial, 6).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerDinnerChairRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("chairs").childInput(legMaterial, 3).childInput(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerClassicChairDyedRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 4).group("chairs").criterion(PFMRecipeProvider.getCriterionNameFromOutput(output), PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 4).input(baseMaterial, 2).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerClassicChairRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("chairs").childInput(legMaterial, 4).childInput(baseMaterial, 2).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerModernChairRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("chairs").childInput(legMaterial, 3).childInput(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerArmChairRecipe(ItemLike output, Ingredient baseMaterial, Ingredient legMaterial, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 2).group("chairs").criterion("has_wool", PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 4).input(baseMaterial, 2).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerSimpleSofaRecipe(ItemLike output, Ingredient baseMaterial, Ingredient legMaterial, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 2).group("chairs").criterion("has_wool", PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 2).input(baseMaterial, 4).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerBasicTableRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 5).childInput(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerBasicDeskRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 4).childInput(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerBasicDeskCabinetRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 4).childInput(baseMaterial, 3).vanillaInput(Ingredient.of((ItemLike[])new ItemLike[]{Items.CHEST})).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerBasicCoffeeTableRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 3).childInput(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerModernCoffeeTableRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 4).childInput(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerClassicCoffeeTableRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 2).childInput(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerClassicTableRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 4).childInput(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerLogTableRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 2).childInput(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerHerringbonePlanks(ItemLike output, Item baseMaterial, RecipeOutput exporter) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)4).define(Character.valueOf('X'), (ItemLike)baseMaterial).pattern("XX").pattern("XX").unlockedBy("has_wood_slabs", PFMRecipeProvider.conditionsFromItem((ItemLike)baseMaterial)).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerDinnerTableRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 3).childInput(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerModernDinnerTableRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 5).childInput(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerClassicNightStandRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("bedroom").childInput(legMaterial, 6).childInput(baseMaterial, 1).vanillaInput((ItemLike)Blocks.CHEST, 1).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static String getCriterionNameFromOutput(ItemLike output) {
        return PFMRecipeProvider.getCriterionNameFromOutput(output, "");
    }

    public static String getEmptyCriteria() {
        return "";
    }

    public static String getCriterionNameFromOutput(ItemLike output, String type) {
        if (Block.byItem((Item)output.asItem()) == null || Block.byItem((Item)output.asItem()) == Blocks.AIR || !PaladinFurnitureMod.furnitureEntryMap.containsKey(Block.byItem((Item)output.asItem()).getClass())) {
            return PFMRecipeProvider.getItemPath(output);
        }
        if (PaladinFurnitureMod.furnitureEntryMap.get(Block.byItem((Item)output.asItem()).getClass()).getVariantFromEntry(Block.byItem((Item)output.asItem())) instanceof WoodVariant) {
            return type.isEmpty() ? "has_planks" : type;
        }
        return PFMRecipeProvider.getItemPath(output);
    }

    public static void offerSimpleBedRecipe(Class<? extends Block> output, String legMaterial, List<ResourceLocation> variants, Ingredient baseBed, RecipeOutput exporter) {
        DyeColor color = ((BedBlock)((BlockItem)Arrays.stream(baseBed.getItems()).findFirst().get().getItem()).getBlock()).getColor();
        DataComponentPatch.Builder builder = DataComponentPatch.builder();
        builder.set(PFMComponents.COLOR_COMPONENT, (Object)color);
        DynamicFurnitureRecipeJsonFactory.create(output, 1, variants, builder.build()).group("bedroom").childInput(legMaterial, 5).vanillaInput(baseBed, 1).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)(output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US) + "_" + color.getSerializedName())));
    }

    public static void offerClassicBedRecipe(Class<? extends Block> output, String legMaterial, List<ResourceLocation> variants, Ingredient baseBed, String fence, RecipeOutput exporter) {
        DyeColor color = ((BedBlock)((BlockItem)Arrays.stream(baseBed.getItems()).findFirst().get().getItem()).getBlock()).getColor();
        DataComponentPatch.Builder builder = DataComponentPatch.builder();
        builder.set(PFMComponents.COLOR_COMPONENT, (Object)color);
        DynamicFurnitureRecipeJsonFactory.create(output, 1, variants, builder.build()).group("bedroom").childInput(legMaterial, 3).childInput(fence, 2).vanillaInput(baseBed, 1).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)(output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US) + "_" + String.valueOf(((BedBlock)((BlockItem)Arrays.stream(baseBed.getItems()).findFirst().get().getItem()).getBlock()).getColor()))));
    }

    public static void offerSimpleBunkLadderRecipe(Class<? extends Block> output, String base, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("bedroom").childInput(base, 1).vanillaInput(Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}), 6).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerLogStoolRecipe(Class<? extends Block> output, String legMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("stools").childInput(legMaterial, 1).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerSimpleStoolRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("stools").childInput(legMaterial, 2).childInput(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerClassicStoolRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("stools").childInput(legMaterial, 3).childInput(baseMaterial, 2).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerModernStoolRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("stools").childInput(legMaterial, 1).childInput(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerCounterRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 6, variants).group("kitchen").childInput(legMaterial, 3).childInput(baseMaterial, 6).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerCounterApplianceRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Ingredient appliance, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 1, variants).group("kitchen").childInput(legMaterial, 3).childInput(baseMaterial, 5).vanillaInput(appliance).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerKitchenSinkRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Ingredient center, Ingredient ingot, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 1, variants).group("kitchen").childInput(legMaterial, 2).childInput(baseMaterial, 5).vanillaInput(ingot).vanillaInput(center).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerWallDrawerRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Ingredient appliace, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 1, variants).group("kitchen").childInput(legMaterial, 6).childInput(baseMaterial, 2).vanillaInput(appliace).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerWallDrawerSmallRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Ingredient appliance, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 3, variants).group("kitchen").childInput(legMaterial, 3).childInput(baseMaterial, 2).vanillaInput(appliance).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerCabinetRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Ingredient chest, RecipeOutput exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 3, variants).group("kitchen").childInput(legMaterial, 6).childInput(baseMaterial, 2).vanillaInput(chest).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerFridgeRecipe(ItemLike output, Ingredient legMaterial, Ingredient storage, RecipeOutput exporter) {
        if (output.asItem().toString().contains("xbox")) {
            SimpleFurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(legMaterial), PFMRecipeProvider.conditionsFromIngredient(legMaterial)).input(legMaterial, 6).input(storage, 1).input(Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE})).input(Ingredient.of((ItemLike[])new ItemLike[]{Items.WHITE_CONCRETE})).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
        } else {
            SimpleFurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(legMaterial), PFMRecipeProvider.conditionsFromIngredient(legMaterial)).input(legMaterial, 7).input(storage).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
        }
    }

    public static void offerFreezerRecipe(ItemLike output, Ingredient legMaterial, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(legMaterial), PFMRecipeProvider.conditionsFromIngredient(legMaterial)).input(legMaterial, 7).input(Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE}), 2).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerMicrowaveRecipe(ItemLike output, Ingredient legMaterial, Ingredient storage, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(legMaterial), PFMRecipeProvider.conditionsFromIngredient(legMaterial)).input(legMaterial, 5).input(storage).input(Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE})).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerRangeHoodRecipe(ItemLike output, Ingredient legMaterial, Ingredient secondMaterial, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(legMaterial), PFMRecipeProvider.conditionsFromIngredient(legMaterial)).input(legMaterial, 4).input(secondMaterial).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerStoveRecipe(ItemLike output, Ingredient legMaterial, Ingredient storage, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(legMaterial), PFMRecipeProvider.conditionsFromIngredient(legMaterial)).input(legMaterial, 8).input(storage).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerStovetopRecipe(ItemLike output, Ingredient base, Ingredient material, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 6).input(material, 2).input(Ingredient.of((ItemLike[])new ItemLike[]{Items.FLINT_AND_STEEL})).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerPlateRecipe(ItemLike output, Ingredient base, Ingredient frame, Ingredient decoration, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 4).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 4).input(frame).input(decoration, 4).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerCutleryRecipe(ItemLike output, Ingredient base, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 4).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 4).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerPendantRecipe(ItemLike output, Ingredient base, Ingredient hang, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 4).group("lighting").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 2).input(hang, 2).input((ItemLike)PaladinFurnitureModBlocksItems.SIMPLE_LIGHT).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerToiletRecipe(ItemLike output, Ingredient base, Ingredient material, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(material), PFMRecipeProvider.conditionsFromIngredient(material)).input(base).input(material, 4).input(Ingredient.of((ItemLike[])new ItemLike[]{Items.BUCKET})).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerWallToiletPaperRecipe(ItemLike output, Ingredient base, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath((ItemLike)Items.PAPER), PFMRecipeProvider.conditionsFromItem((ItemLike)Items.PAPER)).input(base, 1).input((ItemLike)Items.PAPER, 8).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerSinkRecipe(ItemLike output, Ingredient base, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 3).input((ItemLike)Items.STONE_BUTTON, 2).input((ItemLike)Items.IRON_INGOT, 1).input((ItemLike)Items.BUCKET, 1).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerBathtubRecipe(ItemLike output, Ingredient base, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 5).input((ItemLike)Items.STONE_BUTTON, 2).input((ItemLike)Items.BUCKET, 1).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerShowerHeadRecipe(ItemLike output, Ingredient base, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 1).input((ItemLike)Items.REDSTONE, 1).input((ItemLike)Items.IRON_INGOT, 1).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerShowerHandleRecipe(ItemStack output, Ingredient base, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 2).input((ItemLike)Items.REDSTONE, 1).input((ItemLike)Items.IRON_INGOT, 1).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerShowerTowelRecipe(ItemLike output, Ingredient base, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 2).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 4).input(Ingredient.of((ItemLike[])new ItemLike[]{Items.LIGHT_GRAY_CONCRETE}), 2).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerMirrorRecipe(ItemLike output, Ingredient base, RecipeOutput exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 2).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 3).input(Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS}), 2).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> conditionsFromItem(MinMaxBounds.Ints count, ItemLike item) {
        return PFMRecipeProvider.conditionsFromItemPredicates(ItemPredicate.Builder.item().of(new ItemLike[]{item}).withCount(count).build());
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> conditionsFromItem(ItemLike item) {
        return PFMRecipeProvider.conditionsFromItemPredicates(ItemPredicate.Builder.item().of(new ItemLike[]{item}).build());
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> conditionsFromIngredient(Ingredient item) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (ItemStack item1 : item.getItems()) {
            if (items.contains(item1.getItem())) continue;
            items.add(item1.getItem());
        }
        return PFMRecipeProvider.conditionsFromItemPredicates(ItemPredicate.Builder.item().of((ItemLike[])items.toArray(new Item[0])).build());
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> conditionsFromTag(TagKey<Item> tag) {
        return PFMRecipeProvider.conditionsFromItemPredicates(ItemPredicate.Builder.item().of(tag).build());
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> conditionsFromPredicates(ItemPredicate.Builder ... predicates) {
        return PFMRecipeProvider.conditionsFromItemPredicates((ItemPredicate[])Arrays.stream(predicates).map(ItemPredicate.Builder::build).toArray(ItemPredicate[]::new));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> conditionsFromItemPredicates(ItemPredicate ... predicates) {
        return CriteriaTriggers.INVENTORY_CHANGED.createCriterion((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.ANY, List.of(predicates)));
    }

    private static String getItemPath(Ingredient item) {
        ItemStack[] n = item.getItems();
        if (n.length > 0) {
            return BuiltInRegistries.ITEM.getKey((Object)n[0].getItem()).getPath();
        }
        return item.toString();
    }

    private static String getItemPath(ItemLike item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath();
    }
}

