/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.runtime.data;

import com.unlikepaladin.pfm.recipes.SimpleFurnitureRecipe;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.runtime.data.PFMRecipeProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleFurnitureRecipeJsonFactory
implements RecipeBuilder {
    private final ItemStack stack;
    private final NonNullList<Ingredient> inputs = NonNullList.create();
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    private boolean showNotification = true;
    private boolean emptyCriterion = true;
    @Nullable
    private String group;

    public SimpleFurnitureRecipeJsonFactory(ItemLike output, int outputCount) {
        this.stack = new ItemStack(output, outputCount);
    }

    public SimpleFurnitureRecipeJsonFactory(ItemLike output, int outputCount, @NotNull CompoundTag nbtElement) {
        this.stack = new ItemStack(output, outputCount);
        this.stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)nbtElement));
    }

    public SimpleFurnitureRecipeJsonFactory(ItemStack stack) {
        this.stack = stack;
    }

    public static SimpleFurnitureRecipeJsonFactory create(ItemLike output, int count, CompoundTag nbtElement) {
        return new SimpleFurnitureRecipeJsonFactory(output, count, nbtElement);
    }

    public static SimpleFurnitureRecipeJsonFactory create(ItemLike output, CompoundTag nbtElement) {
        return new SimpleFurnitureRecipeJsonFactory(output, 1, nbtElement);
    }

    public static SimpleFurnitureRecipeJsonFactory create(ItemLike output) {
        return new SimpleFurnitureRecipeJsonFactory(output, 1);
    }

    public static SimpleFurnitureRecipeJsonFactory create(ItemLike output, int count) {
        return new SimpleFurnitureRecipeJsonFactory(output, count);
    }

    public static SimpleFurnitureRecipeJsonFactory create(ItemStack stack) {
        return new SimpleFurnitureRecipeJsonFactory(stack);
    }

    public SimpleFurnitureRecipeJsonFactory input(TagKey<Item> tag) {
        return this.input(Ingredient.of(tag));
    }

    public SimpleFurnitureRecipeJsonFactory input(ItemLike itemProvider) {
        return this.input(itemProvider, 1);
    }

    public SimpleFurnitureRecipeJsonFactory input(ItemLike itemProvider, int size) {
        for (int i = 0; i < size; ++i) {
            this.input(Ingredient.of((ItemLike[])new ItemLike[]{itemProvider}));
        }
        return this;
    }

    public SimpleFurnitureRecipeJsonFactory input(Ingredient ingredient) {
        return this.input(ingredient, 1);
    }

    public SimpleFurnitureRecipeJsonFactory input(Ingredient ingredient, int size) {
        for (int i = 0; i < size; ++i) {
            this.inputs.add((Object)ingredient);
        }
        return this;
    }

    public SimpleFurnitureRecipeJsonFactory criterion(String name, Criterion<?> criterionConditions) {
        this.criteria.put(name, criterionConditions);
        this.emptyCriterion = false;
        return this;
    }

    public SimpleFurnitureRecipeJsonFactory group(@Nullable String string) {
        this.group = string;
        return this;
    }

    public SimpleFurnitureRecipeJsonFactory showNotification(boolean showNotification) {
        this.showNotification = showNotification;
        return this;
    }

    public Item getResult() {
        return this.stack.getItem();
    }

    public void save(RecipeOutput exporter, ResourceLocation recipeId) {
        if (this.emptyCriterion) {
            this.criteria.put("has_workbench", PFMRecipeProvider.conditionsFromIngredient(Ingredient.of((ItemLike[])new ItemLike[]{PaladinFurnitureModBlocksItems.WORKING_TABLE})));
        }
        Advancement.Builder advancement$builder = exporter.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        exporter.accept(recipeId, (Recipe)new SimpleFurnitureRecipe(this.group == null || this.group.isBlank() ? " " : this.group, this.stack, (List<Ingredient>)this.inputs), advancement$builder.build(recipeId.withPrefix("recipes/furniture/")));
    }

    private void validate(ResourceLocation recipeId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeId));
        }
    }
}

