/*
 * Decompiled with CFR 0.152.
 */
package net.rogues.datagen;

import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.rogues.block.CustomBlocks;
import net.rogues.item.RogueWeapons;
import net.rogues.item.armor.RogueArmors;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.item.weapon.Weapon;

public class RogueRecipes
extends FabricRecipeProvider {
    public RogueRecipes(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        super(output, registriesFuture);
    }

    public void buildRecipes(RecipeOutput exporter) {
        this.generateDaggerRecipes(exporter);
        this.generateSickleRecipes(exporter);
        this.generateDoubleAxeRecipes(exporter);
        this.generateGlaiveRecipes(exporter);
        this.generateArmorRecipes(exporter);
        this.generateOtherRecipes(exporter);
        this.generateNetheriteUpgrades(exporter);
    }

    private void generateDaggerRecipes(RecipeOutput exporter) {
        this.dagger(exporter, RogueWeapons.flint_dagger, Items.FLINT);
        this.dagger(exporter, RogueWeapons.iron_dagger, Items.IRON_INGOT);
        this.dagger(exporter, RogueWeapons.golden_dagger, Items.GOLD_INGOT);
        this.dagger(exporter, RogueWeapons.diamond_dagger, Items.DIAMOND);
    }

    private void dagger(RecipeOutput exporter, Weapon.Entry daggerEntry, Item material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)daggerEntry.item()).pattern(" M").pattern("S ").define(Character.valueOf('M'), (ItemLike)material).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy(RogueRecipes.getHasName((ItemLike)material), RogueRecipes.has((ItemLike)material)).save(exporter);
    }

    private void generateSickleRecipes(RecipeOutput exporter) {
        this.sickle(exporter, RogueWeapons.iron_sickle, Items.IRON_INGOT);
        this.sickle(exporter, RogueWeapons.golden_sickle, Items.GOLD_INGOT);
        this.sickle(exporter, RogueWeapons.diamond_sickle, Items.DIAMOND);
    }

    private void sickle(RecipeOutput exporter, Weapon.Entry sickleEntry, Item material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)sickleEntry.item()).pattern("MM").pattern("S ").define(Character.valueOf('M'), (ItemLike)material).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy(RogueRecipes.getHasName((ItemLike)material), RogueRecipes.has((ItemLike)material)).save(exporter);
    }

    private void generateDoubleAxeRecipes(RecipeOutput exporter) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)RogueWeapons.stone_double_axe.item()).pattern("MSM").pattern("MSM").pattern(" S ").define(Character.valueOf('M'), ItemTags.STONE_TOOL_MATERIALS).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_cobblestone", RogueRecipes.has((ItemLike)Items.COBBLESTONE)).save(exporter);
        this.doubleAxe(exporter, RogueWeapons.iron_double_axe, Items.IRON_INGOT);
        this.doubleAxe(exporter, RogueWeapons.golden_double_axe, Items.GOLD_INGOT);
        this.doubleAxe(exporter, RogueWeapons.diamond_double_axe, Items.DIAMOND);
    }

    private void doubleAxe(RecipeOutput exporter, Weapon.Entry axeEntry, Item material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)axeEntry.item()).pattern("MSM").pattern("MSM").pattern(" S ").define(Character.valueOf('M'), (ItemLike)material).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy(RogueRecipes.getHasName((ItemLike)material), RogueRecipes.has((ItemLike)material)).save(exporter);
    }

    private void generateGlaiveRecipes(RecipeOutput exporter) {
        this.glaive(exporter, RogueWeapons.iron_glaive, Items.IRON_INGOT);
        this.glaive(exporter, RogueWeapons.golden_glaive, Items.GOLD_INGOT);
        this.glaive(exporter, RogueWeapons.diamond_glaive, Items.DIAMOND);
    }

    private void glaive(RecipeOutput exporter, Weapon.Entry glaiveEntry, Item material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)glaiveEntry.item()).pattern(" MM").pattern("MS ").pattern("S  ").define(Character.valueOf('M'), (ItemLike)material).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy(RogueRecipes.getHasName((ItemLike)material), RogueRecipes.has((ItemLike)material)).save(exporter);
    }

    private void generateArmorRecipes(RecipeOutput exporter) {
        this.generateRogueArmorSet(exporter, RogueArmors.RogueArmorSet_t1, Items.LEATHER, Items.RED_DYE);
        this.generateAssassinArmorSet(exporter, RogueArmors.RogueArmorSet_t2, Items.RABBIT_HIDE, Items.INK_SAC, Items.GOLD_INGOT);
        this.generateWarriorArmorSet(exporter, RogueArmors.WarriorArmorSet_t1, Items.IRON_INGOT, Items.LEATHER, Items.STRING);
        this.generateBerserkerArmorSet(exporter, RogueArmors.WarriorArmorSet_t2, Items.CHAIN, Items.NETHERITE_SCRAP, Items.GOAT_HORN, Items.LEATHER);
    }

    private void generateRogueArmorSet(RecipeOutput exporter, Armor.Set armorSet, Item leather, Item redDye) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.head).pattern("WDW").pattern(" W ").define(Character.valueOf('D'), (ItemLike)redDye).define(Character.valueOf('W'), ItemTags.WOOL).unlockedBy(RogueRecipes.getHasName((ItemLike)leather), RogueRecipes.has((ItemLike)leather)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.chest).pattern("W W").pattern("LWL").pattern("LLL").define(Character.valueOf('L'), (ItemLike)leather).define(Character.valueOf('W'), ItemTags.WOOL).unlockedBy(RogueRecipes.getHasName((ItemLike)leather), RogueRecipes.has((ItemLike)leather)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.legs).pattern("WWW").pattern("L L").pattern("W W").define(Character.valueOf('L'), (ItemLike)leather).define(Character.valueOf('W'), ItemTags.WOOL).unlockedBy(RogueRecipes.getHasName((ItemLike)leather), RogueRecipes.has((ItemLike)leather)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.feet).pattern("W W").pattern("L L").define(Character.valueOf('L'), (ItemLike)leather).define(Character.valueOf('W'), ItemTags.WOOL).unlockedBy(RogueRecipes.getHasName((ItemLike)leather), RogueRecipes.has((ItemLike)leather)).save(exporter);
    }

    private void generateAssassinArmorSet(RecipeOutput exporter, Armor.Set armorSet, Item rabbitHide, Item inkSac, Item gold) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.head).pattern("SGS").pattern("R R").define(Character.valueOf('S'), (ItemLike)inkSac).define(Character.valueOf('G'), (ItemLike)gold).define(Character.valueOf('R'), (ItemLike)rabbitHide).unlockedBy(RogueRecipes.getHasName((ItemLike)rabbitHide), RogueRecipes.has((ItemLike)rabbitHide)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.chest).pattern("S S").pattern("RGR").pattern("RRR").define(Character.valueOf('S'), (ItemLike)inkSac).define(Character.valueOf('G'), (ItemLike)gold).define(Character.valueOf('R'), (ItemLike)rabbitHide).unlockedBy(RogueRecipes.getHasName((ItemLike)rabbitHide), RogueRecipes.has((ItemLike)rabbitHide)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.legs).pattern("SGS").pattern("R R").pattern("R R").define(Character.valueOf('S'), (ItemLike)inkSac).define(Character.valueOf('G'), (ItemLike)gold).define(Character.valueOf('R'), (ItemLike)rabbitHide).unlockedBy(RogueRecipes.getHasName((ItemLike)rabbitHide), RogueRecipes.has((ItemLike)rabbitHide)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.feet).pattern("GSG").pattern("R R").define(Character.valueOf('S'), (ItemLike)inkSac).define(Character.valueOf('G'), (ItemLike)gold).define(Character.valueOf('R'), (ItemLike)rabbitHide).unlockedBy(RogueRecipes.getHasName((ItemLike)rabbitHide), RogueRecipes.has((ItemLike)rabbitHide)).save(exporter);
    }

    private void generateWarriorArmorSet(RecipeOutput exporter, Armor.Set armorSet, Item iron, Item leather, Item string) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.head).pattern("ILI").pattern("I I").define(Character.valueOf('I'), (ItemLike)iron).define(Character.valueOf('L'), (ItemLike)leather).unlockedBy(RogueRecipes.getHasName((ItemLike)iron), RogueRecipes.has((ItemLike)iron)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.chest).pattern("C C").pattern("III").pattern("LLL").define(Character.valueOf('I'), (ItemLike)iron).define(Character.valueOf('L'), (ItemLike)leather).define(Character.valueOf('C'), (ItemLike)string).unlockedBy(RogueRecipes.getHasName((ItemLike)iron), RogueRecipes.has((ItemLike)iron)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.legs).pattern("III").pattern("L L").pattern("I I").define(Character.valueOf('I'), (ItemLike)iron).define(Character.valueOf('L'), (ItemLike)leather).unlockedBy(RogueRecipes.getHasName((ItemLike)iron), RogueRecipes.has((ItemLike)iron)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.feet).pattern("I I").pattern("L L").define(Character.valueOf('I'), (ItemLike)iron).define(Character.valueOf('L'), (ItemLike)leather).unlockedBy(RogueRecipes.getHasName((ItemLike)iron), RogueRecipes.has((ItemLike)iron)).save(exporter);
    }

    private void generateBerserkerArmorSet(RecipeOutput exporter, Armor.Set armorSet, Item chain, Item netheriteScrap, Item goatHorn, Item leather) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.head).pattern("GTG").pattern("I I").define(Character.valueOf('I'), (ItemLike)chain).define(Character.valueOf('G'), (ItemLike)goatHorn).define(Character.valueOf('T'), (ItemLike)netheriteScrap).unlockedBy(RogueRecipes.getHasName((ItemLike)netheriteScrap), RogueRecipes.has((ItemLike)netheriteScrap)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.chest).pattern("T T").pattern("III").pattern("LLL").define(Character.valueOf('I'), (ItemLike)chain).define(Character.valueOf('T'), (ItemLike)netheriteScrap).define(Character.valueOf('L'), (ItemLike)leather).unlockedBy(RogueRecipes.getHasName((ItemLike)netheriteScrap), RogueRecipes.has((ItemLike)netheriteScrap)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.legs).pattern("III").pattern("T T").pattern("I I").define(Character.valueOf('I'), (ItemLike)chain).define(Character.valueOf('T'), (ItemLike)netheriteScrap).unlockedBy(RogueRecipes.getHasName((ItemLike)netheriteScrap), RogueRecipes.has((ItemLike)netheriteScrap)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.feet).pattern("T T").pattern("I I").define(Character.valueOf('I'), (ItemLike)chain).define(Character.valueOf('T'), (ItemLike)netheriteScrap).unlockedBy(RogueRecipes.getHasName((ItemLike)netheriteScrap), RogueRecipes.has((ItemLike)netheriteScrap)).save(exporter);
    }

    private void generateOtherRecipes(RecipeOutput exporter) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)CustomBlocks.WORKBENCH.block()).pattern("PIW").pattern("###").define(Character.valueOf('P'), (ItemLike)Items.PAPER).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('W'), ItemTags.WOOL).define(Character.valueOf('#'), ItemTags.PLANKS).unlockedBy(RogueRecipes.getHasName((ItemLike)Items.PAPER), RogueRecipes.has((ItemLike)Items.PAPER)).showNotification(false).save(exporter);
    }

    private void generateNetheriteUpgrades(RecipeOutput exporter) {
        RogueRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)RogueWeapons.diamond_dagger.item(), (RecipeCategory)RecipeCategory.COMBAT, (Item)RogueWeapons.netherite_dagger.item());
        RogueRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)RogueWeapons.diamond_sickle.item(), (RecipeCategory)RecipeCategory.COMBAT, (Item)RogueWeapons.netherite_sickle.item());
        RogueRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)RogueWeapons.diamond_double_axe.item(), (RecipeCategory)RecipeCategory.COMBAT, (Item)RogueWeapons.netherite_double_axe.item());
        RogueRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)RogueWeapons.diamond_glaive.item(), (RecipeCategory)RecipeCategory.COMBAT, (Item)RogueWeapons.netherite_glaive.item());
        RogueRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)RogueArmors.RogueArmorSet_t2.head, (RecipeCategory)RecipeCategory.COMBAT, (Item)RogueArmors.RogueArmorSet_t3.head);
        RogueRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)RogueArmors.RogueArmorSet_t2.chest, (RecipeCategory)RecipeCategory.COMBAT, (Item)RogueArmors.RogueArmorSet_t3.chest);
        RogueRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)RogueArmors.RogueArmorSet_t2.legs, (RecipeCategory)RecipeCategory.COMBAT, (Item)RogueArmors.RogueArmorSet_t3.legs);
        RogueRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)RogueArmors.RogueArmorSet_t2.feet, (RecipeCategory)RecipeCategory.COMBAT, (Item)RogueArmors.RogueArmorSet_t3.feet);
        RogueRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)RogueArmors.WarriorArmorSet_t2.head, (RecipeCategory)RecipeCategory.COMBAT, (Item)RogueArmors.WarriorArmorSet_t3.head);
        RogueRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)RogueArmors.WarriorArmorSet_t2.chest, (RecipeCategory)RecipeCategory.COMBAT, (Item)RogueArmors.WarriorArmorSet_t3.chest);
        RogueRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)RogueArmors.WarriorArmorSet_t2.legs, (RecipeCategory)RecipeCategory.COMBAT, (Item)RogueArmors.WarriorArmorSet_t3.legs);
        RogueRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)RogueArmors.WarriorArmorSet_t2.feet, (RecipeCategory)RecipeCategory.COMBAT, (Item)RogueArmors.WarriorArmorSet_t3.feet);
    }

    public String getName() {
        return "Rogue Crafting Recipes";
    }
}

