/*
 * Decompiled with CFR 0.152.
 */
package net.rogues.effect;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.rogues.effect.ChargeEffect;
import net.rogues.effect.StealthEffect;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.ConfigFile;
import net.spell_engine.api.config.EffectConfig;
import net.spell_engine.api.effect.ActionImpairing;
import net.spell_engine.api.effect.CustomStatusEffect;
import net.spell_engine.api.effect.Effects;
import net.spell_engine.api.effect.EntityActionsAllowed;
import net.spell_engine.api.effect.OnRemoval;
import net.spell_engine.api.effect.RemoveOnHit;
import net.spell_engine.api.effect.Synchronized;
import net.spell_engine.api.event.CombatEvents;
import net.spell_engine.api.spell.event.SpellEvents;

public class RogueEffects {
    public static final List<Effects.Entry> entries = new ArrayList<Effects.Entry>();
    public static Effects.Entry SLICE_AND_DICE = RogueEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"slice_and_dice"), "Slice and Dice", "Increases attack damage", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x993333), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry SHOCK = RogueEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"shock"), "Stunned", "Prevents movement and actions", (MobEffect)new CustomStatusEffect(MobEffectCategory.HARMFUL, 0xFFFFCC), new EffectConfig(List.of(new AttributeModifier(Attributes.MOVEMENT_SPEED.getRegisteredName(), -1.0f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(Attributes.JUMP_STRENGTH.getRegisteredName(), -1.0f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry SHADOW_STEP = RogueEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"shadow_step"), "Shadow Step", "Untraceable", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0xAAAAAA)));
    public static Effects.Entry STEALTH = RogueEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"stealth"), "Stealth", "Invisible to enemies", (MobEffect)new StealthEffect(MobEffectCategory.BENEFICIAL, 0xAAAAAA), new EffectConfig(List.of(new AttributeModifier(Attributes.MOVEMENT_SPEED.getRegisteredName(), -0.5f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry STEALTH_SPEED = RogueEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"stealth_speed"), "Stealth Speed", "Faster movement in stealth", (MobEffect)new StealthEffect(MobEffectCategory.BENEFICIAL, 0xAAAAAA), new EffectConfig(List.of(new AttributeModifier(Attributes.MOVEMENT_SPEED.getRegisteredName(), 0.5f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry SHATTER = RogueEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"shatter"), "Shattered Armor", "Reduces armor", (MobEffect)new CustomStatusEffect(MobEffectCategory.HARMFUL, 0x800000), new EffectConfig(List.of(new AttributeModifier(Attributes.ARMOR.getRegisteredName(), -0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static final Effects.Entry DEMORALIZE = RogueEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"demoralize"), "Demoralized", "Reduces attack damage", (MobEffect)new CustomStatusEffect(MobEffectCategory.HARMFUL, 0x800000), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), -0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static final Effects.Entry CHARGE = RogueEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"charge"), "Charge", "Increased movement", (MobEffect)new ChargeEffect(MobEffectCategory.BENEFICIAL, 0xAAAAAA), new EffectConfig(List.of(new AttributeModifier(Attributes.MOVEMENT_SPEED.getRegisteredName(), 0.5f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(Attributes.KNOCKBACK_RESISTANCE.getRegisteredName(), 0.5f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));

    private static Effects.Entry add(Effects.Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static void register(ConfigFile.Effects config) {
        Synchronized.configure((MobEffect)RogueEffects.SLICE_AND_DICE.effect, (boolean)true);
        Synchronized.configure((MobEffect)RogueEffects.SHOCK.effect, (boolean)true);
        ActionImpairing.configure((MobEffect)RogueEffects.SHOCK.effect, (EntityActionsAllowed)EntityActionsAllowed.STUN);
        Synchronized.configure((MobEffect)RogueEffects.STEALTH.effect, (boolean)true);
        RemoveOnHit.configure((MobEffect)RogueEffects.STEALTH.effect, (boolean)true);
        Synchronized.configure((MobEffect)RogueEffects.SHATTER.effect, (boolean)true);
        Synchronized.configure((MobEffect)RogueEffects.DEMORALIZE.effect, (boolean)true);
        Synchronized.configure((MobEffect)RogueEffects.CHARGE.effect, (boolean)true);
        CombatEvents.ENTITY_ANY_ATTACK.register(args -> {
            LivingEntity attacker = args.attacker();
            if (attacker.hasEffect(RogueEffects.STEALTH.entry)) {
                attacker.removeEffect(RogueEffects.STEALTH.entry);
            }
        });
        ResourceLocation vanishId = ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"vanish");
        SpellEvents.SPELL_CAST.register(args -> {
            Player caster = args.caster();
            ResourceLocation spellId = ((ResourceKey)args.spell().unwrapKey().get()).location();
            if (caster.hasEffect(RogueEffects.STEALTH.entry) && !spellId.equals((Object)vanishId)) {
                caster.removeEffect(RogueEffects.STEALTH.entry);
            }
        });
        CombatEvents.ITEM_USE.register(args -> {
            LivingEntity user = args.user();
            if (user.hasEffect(RogueEffects.STEALTH.entry)) {
                user.removeEffect(RogueEffects.STEALTH.entry);
            }
        });
        OnRemoval.configure((MobEffect)RogueEffects.STEALTH.effect, context -> {
            StealthEffect.onRemove(context.entity());
            if (context.entity().hasEffect(RogueEffects.STEALTH_SPEED.entry)) {
                context.entity().removeEffect(RogueEffects.STEALTH_SPEED.entry);
            }
        });
        Effects.register(entries, (Map)config.effects);
    }
}

