/*
 * Decompiled with CFR 0.152.
 */
package net.rogues.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.rogues.effect.RogueEffects;
import net.rogues.util.RogueSounds;
import net.spell_engine.api.datagen.SpellBuilder;
import net.spell_engine.api.effect.Effects;
import net.spell_engine.api.render.LightEmission;
import net.spell_engine.api.spell.ExternalSpellSchools;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.internals.target.SpellTarget;
import org.jetbrains.annotations.Nullable;

public class RogueSpells {
    public static final List<Entry> entries = new ArrayList<Entry>();
    public static final Entry SLICE_AND_DICE = RogueSpells.add(RogueSpells.slice_and_dice());
    public static final Entry SHOCK_POWDER = RogueSpells.add(RogueSpells.shock_powder());
    public static final Entry SHADOW_STEP = RogueSpells.add(RogueSpells.shadow_step());
    public static final Entry VANISH = RogueSpells.add(RogueSpells.vanish());
    public static final Entry WARRIOR_THROW = RogueSpells.add(RogueSpells.warrior_throw());
    public static final Entry SHOUT = RogueSpells.add(RogueSpells.shout());
    public static final Entry CHARGE = RogueSpells.add(RogueSpells.charge());
    public static final Entry WHIRLWIND = RogueSpells.add(RogueSpells.whirlwind());

    private static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    private static Spell activeSpellBase() {
        Spell spell = new Spell();
        spell.type = Spell.Type.ACTIVE;
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        spell.active = new Spell.Active();
        spell.active.cast = new Spell.Active.Cast();
        spell.learn = new Spell.Learn();
        return spell;
    }

    private static Spell.Impact createEffectImpact(ResourceLocation effectId, float duration) {
        Spell.Impact buff = new Spell.Impact();
        buff.action = new Spell.Impact.Action();
        buff.action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
        buff.action.status_effect = new Spell.Impact.Action.StatusEffect();
        buff.action.status_effect.effect_id = effectId.toString();
        buff.action.status_effect.duration = duration;
        return buff;
    }

    private static void configureCooldown(Spell spell, float duration) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        spell.cost.cooldown = new Spell.Cost.Cooldown();
        spell.cost.cooldown.duration = duration;
    }

    private static Entry slice_and_dice() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"slice_and_dice");
        String title = "Slice and Dice";
        String description = "";
        Effects.Entry effect = RogueEffects.SLICE_AND_DICE;
        Spell spell = RogueSpells.activeSpellBase();
        spell.range = 0.0f;
        spell.tier = 1;
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RogueSounds.SLICE_AND_DICE.id());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.FLOAT).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.LAUNCH_POINT, 15.0f, 0.15f, 0.2f).preSpawnTravel(7.0f).invert().color(Color.WHITE.toRGBA())};
        spell.deliver.type = Spell.Delivery.Type.STASH_EFFECT;
        spell.deliver.stash_effect = new Spell.Delivery.StashEffect();
        spell.deliver.stash_effect.id = effect.id.toString();
        spell.deliver.stash_effect.consume = 0;
        Spell.Trigger stashMeleeTrigger = new Spell.Trigger();
        stashMeleeTrigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        stashMeleeTrigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.deliver.stash_effect.triggers = List.of(stashMeleeTrigger);
        Spell.Impact buff = RogueSpells.createEffectImpact(effect.id, 10.0f);
        buff.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.ADD;
        buff.action.status_effect.amplifier = 1;
        buff.action.status_effect.amplifier_cap = 9;
        buff.action.status_effect.refresh_duration = false;
        spell.impacts = List.of(buff);
        RogueSpells.configureCooldown(spell, 15.0f);
        spell.cost.exhaust = 0.2f;
        return new Entry(id, spell, title, description, null);
    }

    private static Entry shock_powder() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"shock_powder");
        String title = "Shock Powder";
        String description = "";
        Effects.Entry effect = RogueEffects.SHOCK;
        Spell spell = RogueSpells.activeSpellBase();
        spell.range = 5.0f;
        spell.tier = 2;
        spell.release.animation = "spell_engine:dual_handed_ground_release";
        spell.release.sound = new Sound(RogueSounds.SHOCK_POWDER_RELEASE.id());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.smoke_medium.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, 50.0f, 0.2f, 0.3f).preSpawnTravel(6.0f), new ParticleBatch(SpellEngineParticles.smoke_medium.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, 60.0f, 0.2f, 0.3f).preSpawnTravel(8.0f), new ParticleBatch(SpellEngineParticles.smoke_medium.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 50.0f, 0.25f, 0.25f).preSpawnTravel(4.0f), new ParticleBatch(SpellEngineParticles.electric_arc_A.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 6.0f, 0.01f, 0.05f).extent(3.0f), new ParticleBatch(SpellEngineParticles.electric_arc_B.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 8.0f, 0.01f, 0.05f).extent(5.0f)};
        spell.target.type = Spell.Target.Type.AREA;
        spell.target.area = new Spell.Target.Area();
        spell.target.area.vertical_range_multiplier = 0.5f;
        Spell.Impact buff = RogueSpells.createEffectImpact(effect.id, 3.0f);
        buff.action.status_effect.apply_limit = new Spell.Impact.Action.StatusEffect.ApplyLimit();
        buff.action.status_effect.apply_limit.health_base = 50.0f;
        buff.action.status_effect.apply_limit.spell_power_multiplier = 2.0f;
        buff.sound = new Sound(RogueSounds.SHOCK_POWDER_IMPACT.id());
        spell.impacts = List.of(buff);
        RogueSpells.configureCooldown(spell, 16.0f);
        spell.cost.exhaust = 0.3f;
        return new Entry(id, spell, title, description, null);
    }

    private static Entry shadow_step() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"shadow_step");
        String title = "Shadowstep";
        String description = "";
        Effects.Entry effect = RogueEffects.SHADOW_STEP;
        Spell spell = RogueSpells.activeSpellBase();
        spell.range = 15.0f;
        spell.tier = 3;
        spell.release.animation = "spell_engine:one_handed_area_release";
        spell.release.sound = new Sound(RogueSounds.SHADOW_STEP_DEPART.id());
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.target.aim.required = true;
        Spell.Impact impact = new Spell.Impact();
        impact.action = new Spell.Impact.Action();
        impact.action.type = Spell.Impact.Action.Type.TELEPORT;
        Spell.Impact.Action.Teleport teleport = new Spell.Impact.Action.Teleport();
        teleport.mode = Spell.Impact.Action.Teleport.Mode.BEHIND_TARGET;
        teleport.intent = SpellTarget.Intent.HARMFUL;
        teleport.behind_target = new Spell.Impact.Action.Teleport.BehindTarget();
        teleport.behind_target.distance = 1.5f;
        teleport.depart_particles = new ParticleBatch[]{new ParticleBatch("cloud", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.FEET, 20.0f, 0.05f, 0.1f).preSpawnTravel(15.0f).invert()};
        teleport.arrive_particles = new ParticleBatch[]{new ParticleBatch("poof", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.FEET, 10.0f, 0.05f, 0.1f).preSpawnTravel(2.0f)};
        impact.action.teleport = teleport;
        Spell.Impact buff = RogueSpells.createEffectImpact(effect.id, 1.5f);
        buff.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.SET;
        spell.impacts = List.of(impact, buff);
        RogueSpells.configureCooldown(spell, 12.0f);
        spell.cost.exhaust = 0.4f;
        return new Entry(id, spell, title, description, null);
    }

    private static Entry vanish() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"vanish");
        String title = "Vanish";
        String description = "";
        Effects.Entry effect = RogueEffects.STEALTH;
        Spell spell = RogueSpells.activeSpellBase();
        spell.range = 0.0f;
        spell.tier = 4;
        spell.release.animation = "spell_engine:dual_handed_weapon_cross";
        spell.release.sound = new Sound(RogueSounds.VANISH_COMBINED.id());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.smoke_medium.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 20.0f, 0.12f, 0.15f).preSpawnTravel(3.0f), new ParticleBatch(SpellEngineParticles.smoke_medium.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, 20.0f, 0.12f, 0.15f).preSpawnTravel(4.0f), new ParticleBatch("poof", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 10.0f, 0.01f, 0.1f), new ParticleBatch("campfire_cosy_smoke", ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 10.0f, 0.01f, 0.1f)};
        Spell.Impact buff = RogueSpells.createEffectImpact(effect.id, 8.0f);
        spell.impacts = List.of(buff);
        RogueSpells.configureCooldown(spell, 30.0f);
        spell.cost.exhaust = 0.4f;
        return new Entry(id, spell, title, description, null);
    }

    private static Entry warrior_throw() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"throw");
        String title = "Shattering Throw";
        String description = "";
        Effects.Entry effect = RogueEffects.SHATTER;
        Spell spell = RogueSpells.activeSpellBase();
        spell.range = 24.0f;
        spell.tier = 1;
        spell.active.cast.duration = 0.5f;
        spell.active.cast.animation = "spell_engine:one_handed_throw_charge";
        spell.release.animation = "spell_engine:one_handed_throw_release_instant";
        spell.release.sound = new Sound(RogueSounds.THROW.id());
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.deliver.type = Spell.Delivery.Type.PROJECTILE;
        spell.deliver.projectile = new Spell.Delivery.ShootProjectile();
        spell.deliver.projectile.launch_properties.velocity = 0.8f;
        Spell.ProjectileData projectile = new Spell.ProjectileData();
        projectile.homing_angle = 2.0f;
        projectile.perks.bounce = 1;
        projectile.client_data = new Spell.ProjectileData.Client();
        Spell.ProjectileModel model = new Spell.ProjectileModel();
        model.use_held_item = true;
        model.light_emission = LightEmission.NONE;
        model.rotate_degrees_per_tick = -36.0f;
        model.scale = 1.0f;
        model.orientation = Spell.ProjectileModel.Orientation.ALONG_MOTION;
        projectile.client_data.model = model;
        projectile.travel_sound_interval = 8;
        projectile.travel_sound = new Sound(RogueSounds.THROW.id());
        spell.deliver.projectile.projectile = projectile;
        Spell.Impact damage = new Spell.Impact();
        damage.action = new Spell.Impact.Action();
        damage.action.type = Spell.Impact.Action.Type.DAMAGE;
        damage.action.damage = new Spell.Impact.Action.Damage();
        damage.action.damage.spell_power_coefficient = 1.0f;
        damage.sound = new Sound(RogueSounds.THROW_IMPACT.id());
        Spell.Impact debuff = RogueSpells.createEffectImpact(effect.id, 8.0f);
        debuff.action.status_effect.apply_limit = new Spell.Impact.Action.StatusEffect.ApplyLimit();
        debuff.action.status_effect.apply_limit.health_base = 100.0f;
        debuff.action.status_effect.apply_limit.spell_power_multiplier = 2.0f;
        debuff.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.dripping_blood.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 10.0f, 0.05f, 0.3f)};
        spell.impacts = List.of(damage, debuff);
        RogueSpells.configureCooldown(spell, 8.0f);
        spell.cost.exhaust = 0.3f;
        return new Entry(id, spell, title, description, null);
    }

    private static Entry shout() {
        float radius;
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"shout");
        String title = "Shout";
        String description = "";
        Effects.Entry effect = RogueEffects.DEMORALIZE;
        Spell spell = RogueSpells.activeSpellBase();
        spell.range = radius = 12.0f;
        spell.tier = 2;
        spell.release.animation = "spell_engine:one_handed_shout_release";
        spell.release.sound = new Sound(RogueSounds.SHOUT_RELEASE.id());
        spell.release.particles = new ParticleBatch[]{SpellBuilder.Particles.area((ResourceLocation)SpellEngineParticles.area_effect_609.id()).scale(radius * 0.25f).color(Color.RAGE.alpha(0.5f).toRGBA())};
        spell.target.type = Spell.Target.Type.AREA;
        spell.target.area = new Spell.Target.Area();
        spell.target.area.vertical_range_multiplier = 0.5f;
        Spell.Impact debuff = RogueSpells.createEffectImpact(effect.id, 8.0f);
        debuff.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.ADD;
        debuff.action.status_effect.amplifier = 1;
        debuff.action.status_effect.amplifier_cap = 5;
        debuff.action.status_effect.apply_limit = new Spell.Impact.Action.StatusEffect.ApplyLimit();
        debuff.action.status_effect.apply_limit.health_base = 50.0f;
        debuff.action.status_effect.apply_limit.spell_power_multiplier = 2.0f;
        debuff.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.smoke_medium.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.2f, 0.2f).color(Color.RAGE.toRGBA())};
        debuff.sound = new Sound(RogueSounds.DEMORALIZE_IMPACT.id());
        Spell.Impact damage = new Spell.Impact();
        damage.action = new Spell.Impact.Action();
        damage.action.type = Spell.Impact.Action.Type.DAMAGE;
        damage.action.damage = new Spell.Impact.Action.Damage();
        damage.action.damage.spell_power_coefficient = 0.05f;
        damage.action.damage.knockback = 0.0f;
        spell.impacts = List.of(debuff, damage);
        RogueSpells.configureCooldown(spell, 12.0f);
        spell.cost.exhaust = 0.3f;
        return new Entry(id, spell, title, description, null);
    }

    private static Entry charge() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"charge");
        String title = "Charge";
        String description = "";
        Effects.Entry effect = RogueEffects.CHARGE;
        Spell spell = RogueSpells.activeSpellBase();
        spell.range = 0.0f;
        spell.tier = 3;
        spell.release.animation = "spell_engine:one_handed_area_release";
        spell.release.sound = new Sound(RogueSounds.CHARGE_ACTIVATE.id());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.sign_speed.id().toString(), ParticleBatch.Shape.LINE_VERTICAL, ParticleBatch.Origin.CENTER, 1.0f, 0.75f, 0.75f).scale(0.8f).color(Color.RAGE.toRGBA()).followEntity(true), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.STRIPE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.FLOAT).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 25.0f, 0.2f, 0.25f).extent(-0.2f).color(Color.RAGE.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.1f, 0.1f).extent(0.2f).color(Color.RAGE.toRGBA()), new ParticleBatch(SpellEngineParticles.smoke_medium.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, 50.0f, 0.15f, 0.15f).preSpawnTravel(1.0f)};
        Spell.Impact buff = RogueSpells.createEffectImpact(effect.id, 2.0f);
        spell.impacts = List.of(buff);
        RogueSpells.configureCooldown(spell, 12.0f);
        spell.cost.exhaust = 0.4f;
        return new Entry(id, spell, title, description, null);
    }

    private static Entry whirlwind() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"whirlwind");
        String title = "Whirlwind";
        String description = "";
        Spell spell = RogueSpells.activeSpellBase();
        spell.tier = 4;
        spell.range = 0.0f;
        spell.range_mechanic = Spell.RangeMechanic.MELEE;
        spell.active.cast.duration = 8.0f;
        spell.active.cast.movement_speed = 1.1f;
        spell.active.cast.animation = "spell_engine:two_handed_spin_static";
        spell.active.cast.animation_pitch = false;
        spell.active.cast.channel_ticks = 8;
        spell.active.cast.sound = Sound.withRandomness((ResourceLocation)RogueSounds.WHIRLWIND.id(), (float)0.0f);
        spell.active.cast.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.smoke_medium.id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 1.0f, 0.1f, 0.2f), new ParticleBatch("campfire_cosy_smoke", ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 0.1f, 0.01f, 0.1f)};
        spell.release.sound = new Sound(RogueSounds.THROW.id());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.smoke_medium.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, 25.0f, 0.15f, 0.15f).preSpawnTravel(1.0f)};
        spell.target.type = Spell.Target.Type.AREA;
        spell.target.area = new Spell.Target.Area();
        spell.target.area.vertical_range_multiplier = 0.25f;
        Spell.Impact damage = new Spell.Impact();
        damage.action = new Spell.Impact.Action();
        damage.action.type = Spell.Impact.Action.Type.DAMAGE;
        damage.action.damage = new Spell.Impact.Action.Damage();
        damage.action.damage.spell_power_coefficient = 1.2f;
        damage.action.damage.knockback = 0.8f;
        damage.particles = new ParticleBatch[]{new ParticleBatch("crit", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 30.0f, 0.2f, 0.7f)};
        spell.impacts = List.of(damage);
        RogueSpells.configureCooldown(spell, 30.0f);
        spell.cost.cooldown.proportional = true;
        spell.cost.exhaust = 0.5f;
        return new Entry(id, spell, title, description, null);
    }

    public record Entry(ResourceLocation id, Spell spell, String title, String description, @Nullable SpellTooltip.DescriptionMutator mutator) {
    }
}

