/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.api.leash;

import com.blackgear.platform.common.integration.MobInteraction;
import com.blackgear.vanillabackport.common.api.leash.LeashExtension;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class LeashIntegration
implements MobInteraction {
    public InteractionResult onInteract(Player player, Entity entity, InteractionHand hand) {
        List<Leashable> nearbyMobs;
        LivingEntity living;
        Leashable leashable;
        ItemStack stack = player.getItemInHand(hand);
        if (!entity.level().isClientSide() && player.isSecondaryUseActive() && entity instanceof Leashable && (leashable = (Leashable)entity).canBeLeashed() && entity.isAlive() && (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).isBaby()) && !(nearbyMobs = LeashExtension.vb$leashableInArea(entity, l -> l.getLeashHolder() == player)).isEmpty()) {
            boolean attachedAny = false;
            for (Leashable target : nearbyMobs) {
                if (!((LeashExtension)target).vb$canHaveALeashAttachedTo(entity)) continue;
                target.setLeashedTo(entity, true);
                attachedAny = true;
            }
            if (attachedAny) {
                entity.level().gameEvent((Holder)GameEvent.ENTITY_ACTION, entity.blockPosition(), GameEvent.Context.of((Entity)player));
                entity.playSound(SoundEvents.LEASH_KNOT_PLACE);
                return InteractionResult.SUCCESS;
            }
        }
        if (stack.is(Items.SHEARS) && this.shearOffAllLeashConnections(entity, player)) {
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            return InteractionResult.SUCCESS;
        }
        if (entity.isAlive() && entity instanceof Leashable) {
            leashable = (Leashable)entity;
            if (leashable.getLeashHolder() == player) {
                if (!entity.level().isClientSide()) {
                    leashable.dropLeash(true, !player.isCreative());
                    entity.level().gameEvent((Holder)GameEvent.ENTITY_INTERACT, entity.position(), GameEvent.Context.of((Entity)player));
                    entity.playSound(SoundEvents.LEASH_KNOT_BREAK);
                }
                return InteractionResult.SUCCESS;
            }
            if (stack.is(Items.LEAD) && !(leashable.getLeashHolder() instanceof Player)) {
                if (!entity.level().isClientSide() && ((LeashExtension)leashable).vb$canHaveALeashAttachedTo((Entity)player)) {
                    if (leashable.isLeashed()) {
                        leashable.dropLeash(true, true);
                    }
                    leashable.setLeashedTo((Entity)player, true);
                    entity.playSound(SoundEvents.LEASH_KNOT_PLACE);
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private boolean shearOffAllLeashConnections(Entity entity, Player player) {
        Level level;
        boolean sheared = LeashIntegration.dropAllLeashConnections(entity, player);
        if (sheared && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.playSound(null, entity.blockPosition(), SoundEvents.SHEEP_SHEAR, player != null ? player.getSoundSource() : entity.getSoundSource());
        }
        return sheared;
    }

    public static boolean dropAllLeashConnections(Entity entity, @Nullable Player player) {
        Leashable leashable;
        boolean dropConnections;
        List<Leashable> leashed = LeashExtension.vb$leashableLeashedTo(entity);
        boolean bl = dropConnections = !leashed.isEmpty();
        if (entity instanceof Leashable && (leashable = (Leashable)entity).isLeashed()) {
            leashable.dropLeash(true, true);
            dropConnections = true;
        }
        for (Leashable leashable2 : leashed) {
            leashable2.dropLeash(true, true);
        }
        if (dropConnections) {
            entity.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
            return true;
        }
        return false;
    }
}

