/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.blocks;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ParticleLeavesBlock
extends LeavesBlock {
    private final Supplier<? extends ParticleOptions> particle;
    private final int chance;

    public ParticleLeavesBlock(int chance, Supplier<? extends ParticleOptions> particle, BlockBehaviour.Properties properties) {
        super(properties);
        this.chance = chance;
        this.particle = particle;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockPos below;
        BlockState belowState;
        super.animateTick(state, level, pos, random);
        if (random.nextInt(this.chance) == 0 && !ParticleLeavesBlock.isFaceFull((VoxelShape)(belowState = level.getBlockState(below = pos.below())).getCollisionShape((BlockGetter)level, below), (Direction)Direction.UP)) {
            ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)pos, (RandomSource)random, (ParticleOptions)this.particle.get());
        }
    }
}

