/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.entities.animal;

import com.blackgear.vanillabackport.core.VanillaBackport;
import com.blackgear.vanillabackport.core.data.tags.ModBiomeTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class SheepColorSpawnRules {
    private static final SheepColorSpawnConfiguration TEMPERATE_SPAWN_CONFIGURATION = new SheepColorSpawnConfiguration(SheepColorSpawnRules.weighted((SimpleWeightedRandomList<SheepColorProvider>)SheepColorSpawnRules.builder().add((Object)SheepColorSpawnRules.single(DyeColor.BLACK), 5).add((Object)SheepColorSpawnRules.single(DyeColor.GRAY), 5).add((Object)SheepColorSpawnRules.single(DyeColor.LIGHT_GRAY), 5).add((Object)SheepColorSpawnRules.single(DyeColor.BROWN), 3).add((Object)SheepColorSpawnRules.commonColors(DyeColor.WHITE), 82).build()));
    private static final SheepColorSpawnConfiguration WARM_SPAWN_CONFIGURATION = new SheepColorSpawnConfiguration(SheepColorSpawnRules.weighted((SimpleWeightedRandomList<SheepColorProvider>)SheepColorSpawnRules.builder().add((Object)SheepColorSpawnRules.single(DyeColor.GRAY), 5).add((Object)SheepColorSpawnRules.single(DyeColor.LIGHT_GRAY), 5).add((Object)SheepColorSpawnRules.single(DyeColor.WHITE), 5).add((Object)SheepColorSpawnRules.single(DyeColor.BLACK), 3).add((Object)SheepColorSpawnRules.commonColors(DyeColor.BROWN), 82).build()));
    private static final SheepColorSpawnConfiguration COLD_SPAWN_CONFIGURATION = new SheepColorSpawnConfiguration(SheepColorSpawnRules.weighted((SimpleWeightedRandomList<SheepColorProvider>)SheepColorSpawnRules.builder().add((Object)SheepColorSpawnRules.single(DyeColor.LIGHT_GRAY), 5).add((Object)SheepColorSpawnRules.single(DyeColor.GRAY), 5).add((Object)SheepColorSpawnRules.single(DyeColor.WHITE), 5).add((Object)SheepColorSpawnRules.single(DyeColor.BROWN), 3).add((Object)SheepColorSpawnRules.commonColors(DyeColor.BLACK), 82).build()));

    private static SheepColorProvider commonColors(DyeColor color) {
        return SheepColorSpawnRules.weighted((SimpleWeightedRandomList<SheepColorProvider>)SheepColorSpawnRules.builder().add((Object)SheepColorSpawnRules.single(color), 499).add((Object)SheepColorSpawnRules.single(DyeColor.PINK), 1).build());
    }

    public static DyeColor getRandomSheepColor(DyeColor original, Level level, BlockPos pos, RandomSource random) {
        if (!((Boolean)VanillaBackport.COMMON_CONFIG.hasFarmAnimalVariants.get()).booleanValue()) {
            return original;
        }
        SheepColorSpawnConfiguration config = SheepColorSpawnRules.getSheepColorConfiguration((Holder<Biome>)level.getBiome(pos));
        return config.colors().get(random);
    }

    private static SheepColorSpawnConfiguration getSheepColorConfiguration(Holder<Biome> biome) {
        if (biome.is(ModBiomeTags.SPAWNS_WARM_VARIANT_FARM_ANIMALS)) {
            return WARM_SPAWN_CONFIGURATION;
        }
        return biome.is(ModBiomeTags.SPAWNS_COLD_VARIANT_FARM_ANIMALS) ? COLD_SPAWN_CONFIGURATION : TEMPERATE_SPAWN_CONFIGURATION;
    }

    private static SheepColorProvider weighted(SimpleWeightedRandomList<SheepColorProvider> colors) {
        if (colors.isEmpty()) {
            throw new IllegalArgumentException("List must be non-empty");
        }
        return random -> ((SheepColorProvider)colors.getRandomValue(random).orElseThrow(IllegalStateException::new)).get(random);
    }

    private static SheepColorProvider single(DyeColor color) {
        return random -> color;
    }

    private static SimpleWeightedRandomList.Builder<SheepColorProvider> builder() {
        return SimpleWeightedRandomList.builder();
    }

    static interface SheepColorProvider {
        public DyeColor get(RandomSource var1);
    }

    record SheepColorSpawnConfiguration(SheepColorProvider colors) {
    }
}

