/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.worldgen.placements;

import com.blackgear.platform.common.worldgen.WorldGenRegistry;
import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.blackgear.vanillabackport.common.worldgen.features.SpringToLifeFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightmapPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class SpringToLifePlacements {
    public static final WorldGenRegistry<PlacedFeature> FEATURES = WorldGenRegistry.of((ResourceKey)Registries.PLACED_FEATURE, (String)"minecraft");
    public static final ResourceKey<PlacedFeature> PATCH_BUSH = FEATURES.create("patch_bush");
    public static final ResourceKey<PlacedFeature> PATCH_FIREFLY_BUSH_NEAR_WATER = FEATURES.create("patch_firefly_bush_near_water");
    public static final ResourceKey<PlacedFeature> PATCH_FIREFLY_BUSH_NEAR_WATER_SWAMP = FEATURES.create("patch_firefly_bush_near_water_swamp");
    public static final ResourceKey<PlacedFeature> PATCH_FIREFLY_BUSH_SWAMP = FEATURES.create("patch_firefly_bush_swamp");
    public static final ResourceKey<PlacedFeature> WILDFLOWERS_BIRCH_FOREST = FEATURES.create("wildflowers_birch_forest");
    public static final ResourceKey<PlacedFeature> WILDFLOWERS_MEADOW = FEATURES.create("wildflowers_meadow");
    public static final ResourceKey<PlacedFeature> PATCH_DRY_GRASS_BADLANDS = FEATURES.create("patch_dry_grass_badlands");
    public static final ResourceKey<PlacedFeature> PATCH_DRY_GRASS_DESERT = FEATURES.create("patch_dry_grass_desert");
    public static final ResourceKey<PlacedFeature> PATCH_LEAF_LITTER = FEATURES.create("patch_leaf_litter");
    public static final ResourceKey<PlacedFeature> LEAF_LITTER = FEATURES.create("leaf_litter");
    public static final ResourceKey<PlacedFeature> FALLEN_OAK_TREE = FEATURES.create("fallen_oak_tree");
    public static final ResourceKey<PlacedFeature> FALLEN_BIRCH_TREE = FEATURES.create("fallen_birch_tree");
    public static final ResourceKey<PlacedFeature> FALLEN_SUPER_BIRCH_TREE = FEATURES.create("fallen_super_birch_tree");
    public static final ResourceKey<PlacedFeature> FALLEN_JUNGLE_TREE = FEATURES.create("fallen_jungle_tree");
    public static final ResourceKey<PlacedFeature> FALLEN_SPRUCE_TREE = FEATURES.create("fallen_spruce_tree");
    public static final ResourceKey<PlacedFeature> PLACED_FALLEN_OAK_TREE = FEATURES.create("placed_fallen_oak_tree");
    public static final ResourceKey<PlacedFeature> PLACED_RARE_FALLEN_BIRCH_TREE = FEATURES.create("placed_rare_fallen_birch_tree");
    public static final ResourceKey<PlacedFeature> PLACED_FALLEN_BIRCH_TREE = FEATURES.create("placed_fallen_birch_tree");
    public static final ResourceKey<PlacedFeature> PLACED_FALLEN_SUPER_BIRCH_TREE = FEATURES.create("placed_fallen_super_birch_tree");
    public static final ResourceKey<PlacedFeature> PLACED_FALLEN_JUNGLE_TREE = FEATURES.create("placed_fallen_jungle_tree");
    public static final ResourceKey<PlacedFeature> PLACED_FALLEN_SPRUCE_TREE = FEATURES.create("placed_fallen_spruce_tree");
    public static final ResourceKey<PlacedFeature> PLACED_RARE_FALLEN_SPRUCE_TREE = FEATURES.create("placed_rare_fallen_spruce_tree");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter features = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference patch = features.getOrThrow(SpringToLifeFeatures.PATCH_FIREFLY_BUSH);
        FEATURES.register(context, PATCH_BUSH, (Holder)features.getOrThrow(SpringToLifeFeatures.PATCH_BUSH), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        FEATURES.register(context, PATCH_FIREFLY_BUSH_NEAR_WATER, (Holder)patch, new PlacementModifier[]{CountPlacement.of((int)2), InSquarePlacement.spread(), HeightmapPlacement.onHeightmap((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES), BiomeFilter.biome(), SpringToLifePlacements.nearWaterPredicate(ModBlocks.FIREFLY_BUSH.get())});
        FEATURES.register(context, PATCH_FIREFLY_BUSH_NEAR_WATER_SWAMP, (Holder)patch, new PlacementModifier[]{CountPlacement.of((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome(), SpringToLifePlacements.nearWaterPredicate(ModBlocks.FIREFLY_BUSH.get())});
        FEATURES.register(context, PATCH_FIREFLY_BUSH_SWAMP, (Holder)patch, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)8), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        FEATURES.register(context, WILDFLOWERS_BIRCH_FOREST, (Holder)features.getOrThrow(SpringToLifeFeatures.WILDFLOWERS_BIRCH_FOREST), new PlacementModifier[]{CountPlacement.of((int)3), RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        FEATURES.register(context, WILDFLOWERS_MEADOW, (Holder)features.getOrThrow(SpringToLifeFeatures.WILDFLOWERS_MEADOW), new PlacementModifier[]{NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        FEATURES.register(context, PATCH_DRY_GRASS_BADLANDS, (Holder)features.getOrThrow(SpringToLifeFeatures.PATCH_DRY_GRASS), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)6), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        FEATURES.register(context, PATCH_DRY_GRASS_DESERT, (Holder)features.getOrThrow(SpringToLifeFeatures.PATCH_DRY_GRASS), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        FEATURES.register(context, PATCH_LEAF_LITTER, (Holder)features.getOrThrow(SpringToLifeFeatures.PATCH_LEAF_LITTER), VegetationPlacements.worldSurfaceSquaredWithCount((int)2));
        FEATURES.register(context, FALLEN_OAK_TREE, (Holder)features.getOrThrow(SpringToLifeFeatures.FALLEN_OAK_TREE), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)Blocks.OAK_SAPLING)});
        FEATURES.register(context, FALLEN_BIRCH_TREE, (Holder)features.getOrThrow(SpringToLifeFeatures.FALLEN_BIRCH_TREE), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)Blocks.BIRCH_SAPLING)});
        FEATURES.register(context, FALLEN_SUPER_BIRCH_TREE, (Holder)features.getOrThrow(SpringToLifeFeatures.FALLEN_SUPER_BIRCH_TREE), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)Blocks.BIRCH_SAPLING)});
        FEATURES.register(context, FALLEN_SPRUCE_TREE, (Holder)features.getOrThrow(SpringToLifeFeatures.FALLEN_SPRUCE_TREE), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)Blocks.SPRUCE_SAPLING)});
        FEATURES.register(context, FALLEN_JUNGLE_TREE, (Holder)features.getOrThrow(SpringToLifeFeatures.FALLEN_JUNGLE_TREE), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)Blocks.JUNGLE_SAPLING)});
        FEATURES.register(context, LEAF_LITTER, (Holder)features.getOrThrow(SpringToLifeFeatures.LEAF_LITTER), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)16, (float)0.1f, (int)1)));
        FEATURES.register(context, PLACED_FALLEN_OAK_TREE, (Holder)features.getOrThrow(SpringToLifeFeatures.FALLEN_OAK_TREE), VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)80), (Block)Blocks.OAK_SAPLING));
        FEATURES.register(context, PLACED_RARE_FALLEN_BIRCH_TREE, (Holder)features.getOrThrow(SpringToLifeFeatures.FALLEN_BIRCH_TREE), VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)400), (Block)Blocks.BIRCH_SAPLING));
        FEATURES.register(context, PLACED_FALLEN_BIRCH_TREE, (Holder)features.getOrThrow(SpringToLifeFeatures.FALLEN_BIRCH_TREE), VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)80), (Block)Blocks.BIRCH_SAPLING));
        FEATURES.register(context, PLACED_FALLEN_SUPER_BIRCH_TREE, (Holder)features.getOrThrow(SpringToLifeFeatures.FALLEN_SUPER_BIRCH_TREE), VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)160), (Block)Blocks.BIRCH_SAPLING));
        FEATURES.register(context, PLACED_FALLEN_JUNGLE_TREE, (Holder)features.getOrThrow(SpringToLifeFeatures.FALLEN_JUNGLE_TREE), VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)80), (Block)Blocks.JUNGLE_SAPLING));
        FEATURES.register(context, PLACED_FALLEN_SPRUCE_TREE, (Holder)features.getOrThrow(SpringToLifeFeatures.FALLEN_SPRUCE_TREE), VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)80), (Block)Blocks.SPRUCE_SAPLING));
        FEATURES.register(context, PLACED_RARE_FALLEN_SPRUCE_TREE, (Holder)features.getOrThrow(SpringToLifeFeatures.FALLEN_SPRUCE_TREE), VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)120), (Block)Blocks.SPRUCE_SAPLING));
    }

    public static BlockPredicateFilter nearWaterPredicate(Block block) {
        return BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.ONLY_IN_AIR_PREDICATE, BlockPredicate.wouldSurvive((BlockState)block.defaultBlockState(), (Vec3i)BlockPos.ZERO), BlockPredicate.anyOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.matchesFluids((Vec3i)new BlockPos(1, -1, 0), (Fluid[])new Fluid[]{Fluids.WATER, Fluids.FLOWING_WATER}), BlockPredicate.matchesFluids((Vec3i)new BlockPos(-1, -1, 0), (Fluid[])new Fluid[]{Fluids.WATER, Fluids.FLOWING_WATER}), BlockPredicate.matchesFluids((Vec3i)new BlockPos(0, -1, 1), (Fluid[])new Fluid[]{Fluids.WATER, Fluids.FLOWING_WATER}), BlockPredicate.matchesFluids((Vec3i)new BlockPos(0, -1, -1), (Fluid[])new Fluid[]{Fluids.WATER, Fluids.FLOWING_WATER})})}));
    }
}

