/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.worldgen.treedecorators;

import com.blackgear.vanillabackport.common.registries.ModTreeDecorators;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class PlaceOnGroundDecorator
extends TreeDecorator {
    public static final MapCodec<PlaceOnGroundDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("tries").orElse((Object)128).forGetter(decorator -> decorator.tries), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("radius").orElse((Object)2).forGetter(decorator -> decorator.radius), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("height").orElse((Object)1).forGetter(decorator -> decorator.height), (App)BlockStateProvider.CODEC.fieldOf("block_state_provider").forGetter(decorator -> decorator.blockStateProvider)).apply((Applicative)instance, PlaceOnGroundDecorator::new));
    private final int tries;
    private final int radius;
    private final int height;
    private final BlockStateProvider blockStateProvider;

    public PlaceOnGroundDecorator(int tries, int radius, int height, BlockStateProvider blockStateProvider) {
        this.tries = tries;
        this.radius = radius;
        this.height = height;
        this.blockStateProvider = blockStateProvider;
    }

    protected TreeDecoratorType<?> type() {
        return ModTreeDecorators.PLACE_ON_GROUND.get();
    }

    public void place(TreeDecorator.Context context) {
        ArrayList list = Lists.newArrayList();
        ObjectArrayList list2 = context.roots();
        ObjectArrayList list3 = context.logs();
        if (list2.isEmpty()) {
            list.addAll(list3);
        } else if (!list3.isEmpty() && ((BlockPos)list2.get(0)).getY() == ((BlockPos)list3.get(0)).getY()) {
            list.addAll(list3);
            list.addAll(list2);
        } else {
            list.addAll(list2);
        }
        if (!list.isEmpty()) {
            BlockPos blockPos = (BlockPos)list.get(0);
            int i = blockPos.getY();
            int j = blockPos.getX();
            int k = blockPos.getX();
            int l = blockPos.getZ();
            int m = blockPos.getZ();
            for (BlockPos blockPos2 : list) {
                if (blockPos2.getY() != i) continue;
                j = Math.min(j, blockPos2.getX());
                k = Math.max(k, blockPos2.getX());
                l = Math.min(l, blockPos2.getZ());
                m = Math.max(m, blockPos2.getZ());
            }
            RandomSource randomSource = context.random();
            BoundingBox base = new BoundingBox(j, i, l, k, i, m);
            BoundingBox boundingBox = new BoundingBox(base.minX() - this.radius, base.minY() - this.height, base.minZ() - this.radius, base.maxX() + this.radius, base.maxY() + this.height, base.maxZ() + this.radius);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int n = 0; n < this.tries; ++n) {
                mutableBlockPos.set(randomSource.nextIntBetweenInclusive(boundingBox.minX(), boundingBox.maxX()), randomSource.nextIntBetweenInclusive(boundingBox.minY(), boundingBox.maxY()), randomSource.nextIntBetweenInclusive(boundingBox.minZ(), boundingBox.maxZ()));
                this.attemptToPlaceBlockAbove(context, (BlockPos)mutableBlockPos);
            }
        }
    }

    private void attemptToPlaceBlockAbove(TreeDecorator.Context context, BlockPos pos) {
        BlockPos above = pos.above();
        if (context.level().isStateAtPosition(above, state -> state.isAir() || state.is(Blocks.VINE)) && context.level().isStateAtPosition(pos, state -> state.isSolidRender((BlockGetter)context.level(), pos)) && context.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos).getY() <= above.getY()) {
            context.setBlock(above, this.blockStateProvider.getState(context.random(), above));
        }
    }
}

