/*
 * Decompiled with CFR 0.152.
 */
package dev.danilppzz.potleaves.blocks.base;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import dev.danilppzz.potleaves.blockentity.util.BaseBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public abstract class BlockEntityBase
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public BlockEntityBase(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState(this.buildDefaultState());
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return (entityWorld, pos, entityState, blockEntity) -> {
            if (blockEntity instanceof BaseBlockEntity) {
                BaseBlockEntity machine = (BaseBlockEntity)blockEntity;
                machine.tick();
            }
        };
    }

    protected BlockState buildDefaultState() {
        BlockState state = (BlockState)this.stateDefinition.any();
        if (this.useFacing()) {
            state = (BlockState)state.setValue((Property)FACING, (Comparable)Direction.NORTH);
        }
        return state;
    }

    protected boolean useFacing() {
        return true;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(blockPos)) instanceof ExtendedMenuProvider) {
            ExtendedMenuProvider menu = (ExtendedMenuProvider)blockEntity;
            MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)menu);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        if (this.useFacing()) {
            return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
        }
        return state;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (state.getBlock() != newState.getBlock()) {
            BaseBlockEntity baseBlockEntity;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof BaseBlockEntity && (baseBlockEntity = (BaseBlockEntity)blockEntity).getInventorySize() > 0) {
                if (this.removeOutput()) {
                    baseBlockEntity.removeItemNoUpdate(baseBlockEntity.getInventorySize() - 1);
                }
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)baseBlockEntity);
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, moved);
        }
    }

    public boolean removeOutput() {
        return false;
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.useFacing()) {
            builder.add(new Property[]{FACING});
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = this.defaultBlockState();
        return this.useFacing() ? (BlockState)state.setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite()) : state;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.neighborChanged(state, level, pos, block, fromPos, notify);
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity instanceof BaseBlockEntity ? AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)blockEntity) : 0;
    }
}

