/*
 * Decompiled with CFR 0.152.
 */
package dev.danilppzz.potleaves.inventory;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface ModInventory
extends Container {
    public static ModInventory of(NonNullList<ItemStack> items) {
        return () -> items;
    }

    public static ModInventory create(final int slots) {
        return new ModInventory(){
            private final NonNullList<ItemStack> inventory;
            {
                this.inventory = NonNullList.withSize((int)slots, (Object)ItemStack.EMPTY);
            }

            @Override
            public NonNullList<ItemStack> getItems() {
                return this.inventory;
            }
        };
    }

    public NonNullList<ItemStack> getItems();

    default public int getContainerSize() {
        return this.getItems().size();
    }

    default public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public ItemStack getItem(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    @NotNull
    default public ItemStack removeItem(int slot, int count) {
        ItemStack result = ContainerHelper.removeItem(this.getItems(), (int)slot, (int)count);
        if (!result.isEmpty()) {
            this.setChanged();
        }
        return result;
    }

    @NotNull
    default public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.getItems(), (int)slot);
    }

    default public void setItem(int slot, ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    default public void clearContent() {
        this.getItems().clear();
    }

    default public void setChanged() {
    }

    default public boolean stillValid(Player player) {
        return true;
    }
}

