/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.IServerDataProvider;

public interface StreamServerDataProvider<T extends Accessor<?>, D>
extends IServerDataProvider<T> {
    @Override
    default public void appendServerData(CompoundTag data, T accessor) {
        D value = this.streamData(accessor);
        if (value != null) {
            data.put(this.getUid().toString(), accessor.encodeAsNbt(this.streamCodec(), value));
        }
    }

    default public Optional<D> decodeFromData(T accessor) {
        Tag tag = accessor.getServerData().get(this.getUid().toString());
        if (tag == null) {
            return Optional.empty();
        }
        return accessor.decodeFromNbt(this.streamCodec(), tag);
    }

    @Nullable
    public D streamData(T var1);

    public StreamCodec<RegistryFriendlyByteBuf, D> streamCodec();
}

