/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft;

import com.mojang.logging.LogUtils;
import com.razz.decocraft.Config;
import com.razz.decocraft.common.DecoBedSleepHandler;
import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.common.ModuleEntities;
import com.razz.decocraft.common.ModuleItems;
import com.razz.decocraft.common.ModuleParticleTypes;
import com.razz.decocraft.common.ModuleScreenHandlers;
import com.razz.decocraft.common.ModuleSounds;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.entities.DecoSeatEntity;
import com.razz.decocraft.common.groups.GroupSelector;
import com.razz.decocraft.common.tileentities.AnimatedTileEntity;
import com.razz.decocraft.common.underlay.UnderlayData;
import com.razz.decocraft.common.underlay.UnderlayManager;
import com.razz.decocraft.network.DecocraftPacketHandler;
import com.razz.decocraft.network.server.SSyncAllUnderlays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="decocraft")
public class Decocraft {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"decocraft");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"decocraft");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"decocraft");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"decocraft");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"decocraft");
    private static final Map<UUID, BlockPos> DECOCRAFT_SPAWN_POINTS = new HashMap<UUID, BlockPos>();

    public Decocraft(IEventBus modEventBus, ModContainer modContainer) {
        LOGGER.info("Initializing Decocraft mod");
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(DecocraftPacketHandler::register);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        BLOCK_ENTITY_TYPES.register(modEventBus);
        ENTITY_TYPES.register(modEventBus);
        ModuleSounds.SOUND_EVENTS.register(modEventBus);
        ModuleScreenHandlers.MENU_TYPES.register(modEventBus);
        ModuleParticleTypes.PARTICLE_TYPES.register(modEventBus);
        modEventBus.addListener(event -> {
            if (event.getRegistryKey().equals(Registries.BLOCK)) {
                LOGGER.info("RegisterEvent<Block> fired - registering dynamic blocks");
                ModuleBlocks.initialize(event);
            } else if (event.getRegistryKey().equals(Registries.ITEM)) {
                LOGGER.info("RegisterEvent<Item> fired - registering block items");
                ModuleBlocks.registerBlockItems(event);
            } else if (event.getRegistryKey().equals(Registries.CREATIVE_MODE_TAB)) {
                LOGGER.info("RegisterEvent<CreativeModeTab> fired - registering creative tabs");
                GroupSelector.registerCreativeTabs(event);
            }
        });
        DeferredHolder<EntityType<?>, EntityType<DecoSeatEntity>> unused1 = ModuleEntities.SEAT;
        DeferredHolder<BlockEntityType<?>, BlockEntityType<AnimatedTileEntity>> unused2 = ModuleTileEntities.ANIMATED_TE;
        DeferredItem<Item> unused3 = ModuleItems.RAW_MATERIAL;
        DeferredHolder<ParticleType<?>, SimpleParticleType> unused4 = ModuleParticleTypes.SMOKE_NORMAL;
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        LOGGER.info("Decocraft mod constructor complete");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Decocraft common setup started");
        event.enqueueWork(() -> {
            LOGGER.info("Initializing ModuleItems...");
            ModuleItems.initialize();
            LOGGER.info("Initializing ModuleEntities...");
            ModuleEntities.initialize();
            LOGGER.info("Initializing ModuleTileEntities...");
            ModuleTileEntities.initialize();
            LOGGER.info("Initializing ModuleSounds...");
            ModuleSounds.initialize();
            LOGGER.info("Initializing ModuleScreenHandlers...");
            ModuleScreenHandlers.initialize();
            LOGGER.info("Initializing ModuleParticleTypes...");
            ModuleParticleTypes.initialize();
            LOGGER.info("Registering bed sleep handler events...");
            NeoForge.EVENT_BUS.register(DecoBedSleepHandler.class);
            LOGGER.info("Decocraft common setup enqueued work complete");
        });
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!event.isEndConquered()) {
                Decocraft.handleDecoBedRespawn(player2);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        ServerLevel world;
        UnderlayManager manager;
        Map<BlockPos, UnderlayData> underlays;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && !(underlays = (manager = UnderlayManager.get((Level)(world = (player = (ServerPlayer)player2).serverLevel()))).getAllUnderlays()).isEmpty()) {
            SSyncAllUnderlays packet = SSyncAllUnderlays.createPacket(underlays);
            DecocraftPacketHandler.sendToPlayer(packet, player);
        }
    }

    private static void handleDecoBedRespawn(ServerPlayer player) {
        UUID playerId = player.getUUID();
        BlockPos decoBedPos = DECOCRAFT_SPAWN_POINTS.get(playerId);
        if (decoBedPos != null) {
            ServerLevel world = player.serverLevel();
            Block block = world.getBlockState(decoBedPos).getBlock();
            if (block != null) {
                Vec3 respawnPos = Decocraft.findSafeRespawnPosition((Level)world, decoBedPos);
                if (respawnPos != null) {
                    player.teleportTo(player.serverLevel(), respawnPos.x, respawnPos.y, respawnPos.z, player.getYRot(), player.getXRot());
                    player.setDeltaMovement(Vec3.ZERO);
                    player.fallDistance = 0.0f;
                }
            } else {
                DECOCRAFT_SPAWN_POINTS.remove(playerId);
            }
        }
    }

    public static void setDecoBedSpawnPoint(UUID playerId, BlockPos bedPos) {
        DECOCRAFT_SPAWN_POINTS.put(playerId, bedPos);
    }

    private static Vec3 findSafeRespawnPosition(Level world, BlockPos bedPos) {
        Vec3[] positions;
        for (Vec3 pos : positions = new Vec3[]{Vec3.atBottomCenterOf((Vec3i)bedPos.above()), Vec3.atBottomCenterOf((Vec3i)bedPos.north().above()), Vec3.atBottomCenterOf((Vec3i)bedPos.south().above()), Vec3.atBottomCenterOf((Vec3i)bedPos.east().above()), Vec3.atBottomCenterOf((Vec3i)bedPos.west().above()), Vec3.atBottomCenterOf((Vec3i)bedPos.above(2))}) {
            BlockPos checkPos = BlockPos.containing((Position)pos);
            if (!world.getBlockState(checkPos).isAir() || !world.getBlockState(checkPos.above()).isAir() || world.getBlockState(checkPos.below()).isAir()) continue;
            return pos;
        }
        return Vec3.atBottomCenterOf((Vec3i)bedPos.above());
    }

    public static ResourceLocation getResource(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"decocraft", (String)name);
    }
}

