/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client;

import com.razz.decocraft.client.render.AnimatedRenderer;
import com.razz.decocraft.client.render.DecoPlacementRenderer;
import com.razz.decocraft.client.render.UnderlayWorldRenderer;
import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.common.ModuleEntities;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.blocks.DecoBedBlock;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.models.bbmodel.BBModel;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="decocraft", value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ClientEvents.setupRenderLayers();
            ClientEvents.registerBBModels();
        });
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModuleEntities.SEAT.get(), NoopRenderer::new);
    }

    @SubscribeEvent
    public static void onRegisterBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        if (ModuleTileEntities.ANIMATED_TE != null) {
            event.registerBlockEntityRenderer((BlockEntityType)ModuleTileEntities.ANIMATED_TE.get(), AnimatedRenderer::new);
        }
    }

    private static void setupRenderLayers() {
        for (Map.Entry<String, Block> entry : ModuleBlocks.DECOBLOCKS.entrySet()) {
            if (entry.getValue() instanceof DecocraftBlock) {
                DecocraftBlock block = (DecocraftBlock)entry.getValue();
                if (!Objects.equals(block.meta.type, "animated")) {
                    RenderType renderer = !block.meta.transparency ? RenderType.cutout() : RenderType.translucent();
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderer);
                    continue;
                }
                ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.translucent());
                continue;
            }
            if (!(entry.getValue() instanceof DecoBedBlock)) continue;
            DecoBedBlock bedBlock = (DecoBedBlock)entry.getValue();
            ItemBlockRenderTypes.setRenderLayer((Block)bedBlock, (RenderType)RenderType.cutout());
        }
    }

    private static void registerBBModels() {
        for (Map.Entry<String, Block> entry : ModuleBlocks.DECOBLOCKS.entrySet()) {
            String materialName = entry.getKey();
            Block block = entry.getValue();
            if (block instanceof DecocraftBlock) {
                DecocraftBlock decoBlock = (DecocraftBlock)block;
                if (decoBlock.model == null) continue;
                ClientEvents.registerBBModelForBlock(materialName, decoBlock.model, decoBlock.meta);
                continue;
            }
            if (!(block instanceof DecoBedBlock)) continue;
            DecoBedBlock bedBlock = (DecoBedBlock)block;
            if (bedBlock.model == null) continue;
            ClientEvents.registerBBModelForBlock(materialName, bedBlock.model, bedBlock.meta);
        }
    }

    private static void registerBBModelForBlock(String materialName, BBModel model, JsonContainer.Entry meta) {
        float scale = meta.scale != 0.0f ? meta.scale : 1.0f;
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            UnderlayWorldRenderer.renderUnderlays(event);
        }
        DecoPlacementRenderer.renderPlacementPreview(event);
    }
}

