/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client.network;

import com.razz.decocraft.common.underlay.UnderlayData;
import com.razz.decocraft.common.underlay.UnderlayManager;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;

public class ClientPacketHandler {
    public static void handleSyncUnderlayAdd(BlockPos pos, String modelId, String materialId, Direction facing) {
        Minecraft client = Minecraft.getInstance();
        if (client.level == null) {
            return;
        }
        UnderlayData data = new UnderlayData(modelId, materialId, facing);
        UnderlayManager manager = UnderlayManager.get((Level)client.level);
        manager.setUnderlay(pos, data);
    }

    public static void handleSyncUnderlayRemove(BlockPos pos) {
        Minecraft client = Minecraft.getInstance();
        if (client.level == null) {
            return;
        }
        UnderlayManager manager = UnderlayManager.get((Level)client.level);
        manager.removeUnderlay(pos);
    }

    public static void handleSyncAllUnderlays(Map<BlockPos, UnderlayData> underlays) {
        Minecraft client = Minecraft.getInstance();
        if (client.level == null) {
            return;
        }
        UnderlayManager manager = UnderlayManager.get((Level)client.level);
        for (Map.Entry<BlockPos, UnderlayData> entry : underlays.entrySet()) {
            manager.setUnderlay(entry.getKey(), entry.getValue());
        }
    }
}

