/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.common.underlay.UnderlayData;
import com.razz.decocraft.common.underlay.UnderlayManager;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBUnbakedModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Quaternionf;

public class UnderlayWorldRenderer {
    private static final Map<String, BakedModel> MODEL_CACHE = new HashMap<String, BakedModel>();
    private static final RandomSource random = RandomSource.create();

    public static void renderUnderlays(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        if (client.level == null) {
            return;
        }
        UnderlayManager manager = UnderlayManager.get((Level)client.level);
        Map<BlockPos, UnderlayData> underlays = manager.getAllUnderlays();
        if (underlays.isEmpty()) {
            return;
        }
        PoseStack matrices = event.getPoseStack();
        Vec3 camera = event.getCamera().getPosition();
        MultiBufferSource.BufferSource immediate = client.renderBuffers().bufferSource();
        for (Map.Entry<BlockPos, UnderlayData> entry : underlays.entrySet()) {
            BlockPos pos = entry.getKey();
            UnderlayData data = entry.getValue();
            if (!data.isValid() || pos.distToCenterSqr((Position)camera) > 4096.0) continue;
            UnderlayWorldRenderer.renderUnderlay(matrices, (MultiBufferSource)immediate, pos, data, camera);
        }
        immediate.endBatch(RenderType.solid());
        immediate.endBatch(RenderType.cutout());
        immediate.endBatch(RenderType.cutoutMipped());
        immediate.endBatch(RenderType.translucent());
        RenderSystem.disableBlend();
    }

    private static void renderUnderlay(PoseStack matrices, MultiBufferSource consumers, BlockPos pos, UnderlayData data, Vec3 camera) {
        String materialId = data.getMaterialId();
        BakedModel model = UnderlayWorldRenderer.getBakedModel(materialId);
        if (model == null) {
            return;
        }
        matrices.pushPose();
        matrices.translate((double)pos.getX() - camera.x, (double)pos.getY() - camera.y, (double)pos.getZ() - camera.z);
        Direction facing = data.getFacing();
        UnderlayWorldRenderer.applyDirectionRotation(matrices, facing);
        Minecraft client = Minecraft.getInstance();
        int packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)client.level, (BlockPos)pos);
        VertexConsumer buffer = consumers.getBuffer(RenderType.cutout());
        List quads = model.getQuads(null, null, random);
        for (BakedQuad quad : quads) {
            buffer.putBulkData(matrices.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, packedLight, 0);
        }
        for (Direction direction : Direction.values()) {
            List faceQuads = model.getQuads(null, direction, random);
            for (BakedQuad quad : faceQuads) {
                buffer.putBulkData(matrices.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, packedLight, 0);
            }
        }
        matrices.popPose();
    }

    private static BakedModel getBakedModel(String materialId) {
        if (MODEL_CACHE.containsKey(materialId)) {
            return MODEL_CACHE.get(materialId);
        }
        BBModel bbModel = ModuleBlocks.MAT_TO_BB_MODEL.get(materialId);
        if (bbModel == null) {
            return null;
        }
        JsonContainer.Entry entry = ModuleBlocks.MAT_TO_ENTRY.get(materialId);
        if (entry == null) {
            return null;
        }
        BBUnbakedModel unbakedModel = new BBUnbakedModel(materialId, bbModel);
        Minecraft client = Minecraft.getInstance();
        BakedModel bakedModel = unbakedModel.bake(null, spriteId -> client.getModelManager().getAtlas(spriteId.atlasLocation()).getSprite(spriteId.texture()), null);
        if (bakedModel != null) {
            MODEL_CACHE.put(materialId, bakedModel);
        }
        return bakedModel;
    }

    private static void applyDirectionRotation(PoseStack matrices, Direction facing) {
        matrices.translate(0.5, 0.5, 0.5);
        switch (facing) {
            case NORTH: {
                break;
            }
            case SOUTH: {
                matrices.mulPose(new Quaternionf().rotationY((float)Math.toRadians(180.0)));
                break;
            }
            case WEST: {
                matrices.mulPose(new Quaternionf().rotationY((float)Math.toRadians(90.0)));
                break;
            }
            case EAST: {
                matrices.mulPose(new Quaternionf().rotationY((float)Math.toRadians(-90.0)));
                break;
            }
        }
        matrices.translate(-0.5, -0.5, -0.5);
    }
}

