/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.blocks;

import com.razz.decocraft.Decocraft;
import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.common.tileentities.DecoStorageTileEntity;
import com.razz.decocraft.models.bbmodel.BBModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class DecoStorageBlock
extends DecocraftBlock {
    public DecoStorageBlock(JsonContainer.Entry meta, BBModel model) {
        super(meta, model);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide && this.meta.decoref != null && this.meta.decoref.contains("locker")) {
            Decocraft.LOGGER.info("useItemOn called for locker: {}, stack: {}", (Object)this.meta.decoref, (Object)stack.getItem());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (!level.isClientSide) {
            BlockItem blockItem;
            ItemStack mainHand = player.getMainHandItem();
            ItemStack offHand = player.getOffhandItem();
            if (mainHand.getItem() instanceof BlockItem && (blockItem = (BlockItem)mainHand.getItem()).getBlock() == blockState.getBlock()) {
                return InteractionResult.PASS;
            }
            if (offHand.getItem() instanceof BlockItem && (blockItem = (BlockItem)offHand.getItem()).getBlock() == blockState.getBlock()) {
                return InteractionResult.PASS;
            }
        }
        if (player.isCrouching() && this.meta.script != null && this.meta.script.shift_on_use != null) {
            DecoStorageBlock.script(level, blockPos, blockState, this.meta.script.shift_on_use);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!player.isCrouching() && this.meta.script != null && this.meta.script.on_use != null) {
            if (this.meta.script.on_use.storage != null && this.meta.script.on_use.storage.length == 2) {
                if (!level.isClientSide) {
                    BlockEntity blockEntity;
                    if (this.meta.script.on_use.link != null) {
                        DecoStorageBlock.scriptLink(level, blockPos, blockState, this.meta.script.on_use.link);
                    }
                    if ((blockEntity = level.getBlockEntity(blockPos)) instanceof DecoStorageTileEntity) {
                        DecoStorageTileEntity storage = (DecoStorageTileEntity)blockEntity;
                        player.openMenu((MenuProvider)blockEntity, buf -> {
                            buf.writeInt(storage.getWidth());
                            buf.writeInt(storage.getHeight());
                        });
                    }
                    if (this.meta.script.on_use.sound != null) {
                        DecoStorageBlock.scriptSound(level, blockPos, level.getBlockState(blockPos), this.meta.script.on_use.sound);
                    }
                    if (this.meta.script.on_use.animations != null) {
                        DecoStorageBlock.scriptAnimations(level, blockPos, level.getBlockState(blockPos), this.meta.script.on_use.animations);
                    }
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            DecoStorageBlock.script(level, blockPos, blockState, this.meta.script.on_use);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        int width = 3;
        int height = 6;
        if (this.meta.script != null) {
            if (this.meta.script.on_use != null && this.meta.script.on_use.storage != null && this.meta.script.on_use.storage.length == 2) {
                width = this.meta.script.on_use.storage[0];
                height = this.meta.script.on_use.storage[1];
            } else if (this.meta.script.shift_on_use != null && this.meta.script.shift_on_use.storage != null && this.meta.script.shift_on_use.storage.length == 2) {
                width = this.meta.script.shift_on_use.storage[0];
                height = this.meta.script.shift_on_use.storage[1];
            }
        }
        return new DecoStorageTileEntity(pos, state, width, height);
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        if (this.meta != null && this.meta.script != null && this.meta.script.on_use != null && this.meta.script.on_use.storage != null && this.meta.script.on_use.storage.length == 2) {
            return true;
        }
        return super.hasTileEntity(state);
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        BlockEntity blockEntity;
        String newName;
        if (moved || state.is(newState.getBlock())) {
            super.onRemove(state, level, pos, newState, moved);
            return;
        }
        String oldName = state.getBlock().toString().replace("_open", "");
        if (oldName.equals(newName = newState.getBlock().toString().replace("_open", "")) || newState.getBlock() instanceof DecoStorageBlock) {
            super.onRemove(state, level, pos, newState, moved);
            return;
        }
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof DecoStorageTileEntity) {
            DecoStorageTileEntity storage = (DecoStorageTileEntity)blockEntity;
            for (ItemStack stack : storage.getItems()) {
                if (stack.isEmpty()) continue;
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
            }
        }
        super.onRemove(state, level, pos, newState, moved);
    }

    @Override
    public void onToolModelSwitch(BlockState state, Level level, BlockPos pos) {
        BlockEntity newBlockEntity;
        BlockEntity blockEntity;
        if (this.meta == null || this.meta.script == null || this.meta.script.tool_modelswitch == null || this.meta.script.tool_modelswitch.link == null) {
            return;
        }
        String link = this.meta.script.tool_modelswitch.link;
        Block target = ModuleBlocks.DECOBLOCKS.get(link);
        if (target == null) {
            return;
        }
        CompoundTag tileEntityData = null;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof DecoStorageTileEntity) {
            DecoStorageTileEntity storage = (DecoStorageTileEntity)blockEntity;
            tileEntityData = new CompoundTag();
            storage.saveAdditional(tileEntityData, (HolderLookup.Provider)level.registryAccess());
        }
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        BlockState newState = (BlockState)target.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
        level.setBlock(pos, newState, 3);
        if (!level.isClientSide && tileEntityData != null && (newBlockEntity = level.getBlockEntity(pos)) instanceof DecoStorageTileEntity) {
            DecoStorageTileEntity storage = (DecoStorageTileEntity)newBlockEntity;
            storage.loadAdditional(tileEntityData, (HolderLookup.Provider)level.registryAccess());
            storage.setChanged();
        }
        if (this.meta.script.tool_modelswitch.sound != null) {
            DecoStorageBlock.scriptSound(level, pos, newState, this.meta.script.tool_modelswitch.sound);
        }
        if (this.meta.script.tool_modelswitch.animations != null) {
            DecoStorageBlock.scriptAnimations(level, pos, newState, this.meta.script.tool_modelswitch.animations);
        }
    }
}

