/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.tileentities;

import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.ModuleParticleTypes;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import com.razz.decocraft.models.libgdx.Vector3;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class DecocraftTileEntity
extends BlockEntity {
    private static final String NBT_COUNTER = "counter";
    private static final String NBT_FRAMETIME = "frametime";
    private static final String NBT_CURRENT_FRAME = "currentFrame";
    private static final String NBT_FRAME_TIMER = "frameTimer";
    private static final String NBT_LIT = "lit";
    public final JsonContainer.Entry meta;
    private int counter;
    private int frametime;
    private boolean lit = true;
    private int currentFrame = 0;
    private int frameTimer = 0;

    public DecocraftTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type != null ? type : (BlockEntityType)ModuleTileEntities.DECOCRAFT.get(), pos, state);
        if (state.getBlock() instanceof DecocraftBlock) {
            this.meta = ((DecocraftBlock)state.getBlock()).meta;
            this.counter = this.meta != null && this.meta.script != null ? this.meta.script.counter : -1;
            this.frametime = this.meta != null && this.meta.flipbook != null ? this.meta.flipbook.frametime : -1;
        } else {
            this.meta = null;
            this.counter = -1;
            this.frametime = -1;
        }
    }

    public DecocraftTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, JsonContainer.Entry meta) {
        super(type, pos, state);
        this.meta = meta;
        this.counter = -1;
        this.frametime = -1;
    }

    public DecocraftTileEntity(JsonContainer.Entry meta) {
        super((BlockEntityType)ModuleTileEntities.DECOCRAFT.get(), BlockPos.ZERO, null);
        if (meta != null) {
            this.meta = meta;
            this.counter = meta.script.counter;
            this.frametime = meta.flipbook.frametime;
        } else {
            this.meta = null;
            this.counter = -1;
            this.frametime = -1;
        }
    }

    public static void tick(Level world, BlockPos pos, BlockState state, DecocraftTileEntity blockEntity) {
        blockEntity.tick();
    }

    private void tick() {
        if (this.counter >= 0) {
            --this.counter;
            if (this.counter == 0) {
                this.counter = this.meta.script.counter;
                DecocraftBlock.script(this.getLevel(), this.getBlockPos(), this.getBlockState(), this.meta.script.trigger);
            }
        }
        this.spawnParticles();
    }

    private void spawnParticles() {
        if (this.level == null || !this.level.isClientSide) {
            return;
        }
        if (this.meta == null || this.meta.script == null || this.meta.script.particles == null) {
            return;
        }
        BBModel model = null;
        if (this.getBlockState().getBlock() instanceof DecocraftBlock) {
            model = ((DecocraftBlock)this.getBlockState().getBlock()).model;
        }
        if (model == null || model.locators == null || model.locators.isEmpty()) {
            return;
        }
        BlockState state = this.getBlockState();
        Direction facing = state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) ? (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) : Direction.NORTH;
        for (Map.Entry<String, JsonContainer.Particle> particleEntry : this.meta.script.particles.entrySet()) {
            ParticleOptions particleType;
            String locatorName = particleEntry.getKey();
            JsonContainer.Particle particleConfig = particleEntry.getValue();
            BBModelParts.Locator locator = model.locators.get(locatorName);
            if (locator == null) {
                locator = model.locators.get("particle_" + locatorName);
            }
            if (locator == null || locator.position == null || particleConfig.delay > 0 && System.currentTimeMillis() % (long)(particleConfig.delay * 50) > 25L || (particleType = this.getParticleFromName(particleConfig.name)) == null) continue;
            Vector3 transformedPos = this.transformPosition(locator.position, facing);
            double worldX = (double)this.worldPosition.getX() + 0.5 + (double)transformedPos.x / 16.0;
            double worldY = (double)this.worldPosition.getY() + (double)transformedPos.y / 16.0;
            double worldZ = (double)this.worldPosition.getZ() + 0.5 + (double)transformedPos.z / 16.0;
            double vx = particleConfig.vx;
            double vy = particleConfig.vy;
            double vz = particleConfig.vz;
            if (vx == 0.0 && vy == 0.0 && vz == 0.0 && particleConfig.name != null && particleConfig.name.contains("falling_water")) {
                vy = -0.05;
            }
            this.level.addParticle(particleType, worldX, worldY, worldZ, vx, vy, vz);
        }
    }

    private Vector3 transformPosition(Vector3 pos, Direction facing) {
        if (pos == null) {
            return new Vector3(0.0f, 0.0f, 0.0f);
        }
        float x = pos.x;
        float y = pos.y;
        float z = pos.z;
        return switch (facing) {
            case Direction.NORTH -> new Vector3(x, y, z);
            case Direction.SOUTH -> new Vector3(-x, y, -z);
            case Direction.EAST -> new Vector3(-z, y, x);
            case Direction.WEST -> new Vector3(z, y, -x);
            default -> new Vector3(x, y, z);
        };
    }

    private ParticleOptions getParticleFromName(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("decocraft:")) {
            String particleName;
            switch (particleName = name.substring("decocraft:".length())) {
                case "falling_water_random": {
                    return (ParticleOptions)ModuleParticleTypes.FALLING_WATER.get();
                }
                case "smoke_normal": {
                    return (ParticleOptions)ModuleParticleTypes.SMOKE_NORMAL.get();
                }
                case "smoke_small": {
                    return (ParticleOptions)ModuleParticleTypes.SMOKE_SMALL.get();
                }
                case "flame_normal": {
                    return (ParticleOptions)ModuleParticleTypes.FLAME_NORMAL.get();
                }
                case "flame_small": {
                    return (ParticleOptions)ModuleParticleTypes.FLAME_SMALL.get();
                }
            }
        } else if (name.startsWith("minecraft:")) {
            String particleName;
            switch (particleName = name.substring("minecraft:".length())) {
                case "splash": {
                    return ParticleTypes.SPLASH;
                }
                case "bubble": {
                    return ParticleTypes.BUBBLE;
                }
                case "dripping_water": {
                    return ParticleTypes.DRIPPING_WATER;
                }
                case "falling_water": {
                    return ParticleTypes.FALLING_WATER;
                }
            }
        }
        return null;
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        if (nbt.contains(NBT_COUNTER)) {
            this.counter = nbt.getInt(NBT_COUNTER);
        }
        if (nbt.contains(NBT_FRAMETIME)) {
            this.frametime = nbt.getInt(NBT_FRAMETIME);
        }
        if (nbt.contains(NBT_CURRENT_FRAME)) {
            this.currentFrame = nbt.getInt(NBT_CURRENT_FRAME);
        }
        if (nbt.contains(NBT_FRAME_TIMER)) {
            this.frameTimer = nbt.getInt(NBT_FRAME_TIMER);
        }
        if (nbt.contains(NBT_LIT)) {
            this.lit = nbt.getBoolean(NBT_LIT);
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt(NBT_COUNTER, this.counter);
        nbt.putInt(NBT_FRAMETIME, this.frametime);
        nbt.putInt(NBT_CURRENT_FRAME, this.currentFrame);
        nbt.putInt(NBT_FRAME_TIMER, this.frameTimer);
        nbt.putBoolean(NBT_LIT, this.lit);
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public boolean isLit() {
        return this.lit;
    }

    public void setLit(boolean lit) {
        this.lit = lit;
    }

    private void syncToClients() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.getChunkSource().blockChanged(this.getBlockPos());
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveWithoutMetadata(registryLookup);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

