/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.underlay;

import com.razz.decocraft.common.underlay.UnderlayData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class UnderlayManager
extends SavedData {
    private static final String DATA_NAME = "decocraft_underlays";
    private final Map<BlockPos, UnderlayData> underlays = new ConcurrentHashMap<BlockPos, UnderlayData>();
    private static UnderlayManager clientInstance = null;

    public static UnderlayManager get(Level level) {
        if (level.isClientSide) {
            if (clientInstance == null) {
                clientInstance = new UnderlayManager();
            }
            return clientInstance;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return (UnderlayManager)serverLevel.getDataStorage().computeIfAbsent(new SavedData.Factory(UnderlayManager::new, UnderlayManager::load, null), DATA_NAME);
    }

    public void setUnderlay(BlockPos pos, UnderlayData data) {
        if (data.isValid()) {
            this.underlays.put(pos.immutable(), data);
            this.setDirty();
        }
    }

    public UnderlayData getUnderlay(BlockPos pos) {
        return this.underlays.getOrDefault(pos, UnderlayData.NONE);
    }

    public void removeUnderlay(BlockPos pos) {
        if (this.underlays.remove(pos) != null) {
            this.setDirty();
            System.out.println("[UnderlayManager] Removed underlay at " + String.valueOf(pos));
        }
    }

    public boolean hasUnderlay(BlockPos pos) {
        return this.underlays.containsKey(pos) && this.underlays.get(pos).isValid();
    }

    public Map<BlockPos, UnderlayData> getAllUnderlays() {
        return new HashMap<BlockPos, UnderlayData>(this.underlays);
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registries) {
        ListTag list = new ListTag();
        for (Map.Entry<BlockPos, UnderlayData> entry : this.underlays.entrySet()) {
            CompoundTag entryNbt = new CompoundTag();
            BlockPos pos = entry.getKey();
            entryNbt.putInt("x", pos.getX());
            entryNbt.putInt("y", pos.getY());
            entryNbt.putInt("z", pos.getZ());
            entryNbt.put("data", (Tag)entry.getValue().toNbt());
            list.add((Object)entryNbt);
        }
        nbt.put("underlays", (Tag)list);
        return nbt;
    }

    public static UnderlayManager load(CompoundTag nbt, HolderLookup.Provider registries) {
        UnderlayManager manager = new UnderlayManager();
        if (nbt.contains("underlays")) {
            ListTag list = nbt.getList("underlays", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag entryNbt = list.getCompound(i);
                BlockPos pos = new BlockPos(entryNbt.getInt("x"), entryNbt.getInt("y"), entryNbt.getInt("z"));
                UnderlayData data = UnderlayData.fromNbt(entryNbt.getCompound("data"));
                if (!data.isValid()) continue;
                manager.underlays.put(pos, data);
            }
        }
        return manager;
    }
}

