/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.server;

import com.razz.decocraft.Decocraft;
import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.common.underlay.UnderlayData;
import com.razz.decocraft.common.underlay.UnderlayManager;
import com.razz.decocraft.network.DecocraftPacketHandler;
import com.razz.decocraft.network.server.SSyncUnderlayRemove;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="decocraft")
public class ServerEvents {
    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        ServerLevel world = (ServerLevel)event.getLevel();
        BlockPos clickedPos = event.getPos();
        ServerPlayer player = (ServerPlayer)event.getEntity();
        UnderlayManager manager = UnderlayManager.get((Level)world);
        for (Direction direction : Direction.values()) {
            String materialId;
            Block block;
            BlockPos underlayPos = clickedPos.relative(direction);
            UnderlayData underlayData = manager.getUnderlay(underlayPos);
            if (underlayData == null || !underlayData.isValid()) continue;
            Decocraft.LOGGER.info("Breaking underlay at {} (clicked block at {})", (Object)underlayPos, (Object)clickedPos);
            manager.removeUnderlay(underlayPos);
            SSyncUnderlayRemove packet = new SSyncUnderlayRemove(underlayPos);
            for (ServerPlayer serverPlayer : world.players()) {
                DecocraftPacketHandler.sendToPlayer(packet, serverPlayer);
            }
            if (!player.isCreative() && (block = ModuleBlocks.DECOBLOCKS.get(materialId = underlayData.getMaterialId())) != null) {
                ItemStack itemStack = new ItemStack((ItemLike)block);
                ItemEntity itemEntity = new ItemEntity((Level)world, (double)underlayPos.getX() + 0.5, (double)underlayPos.getY() + 0.5, (double)underlayPos.getZ() + 0.5, itemStack);
                itemEntity.setDefaultPickUpDelay();
                world.addFreshEntity((Entity)itemEntity);
            }
            world.playSound(null, underlayPos, SoundEvents.WOOL_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
    }
}

