/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.main.network;

import com.dooji.underlay.client.UnderlayClient;
import com.dooji.underlay.main.UnderlayManager;
import com.dooji.underlay.main.network.payloads.AddOverlayPayload;
import com.dooji.underlay.main.network.payloads.RemoveOverlayPayload;
import com.dooji.underlay.main.network.payloads.SyncOverlaysPayload;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class UnderlayNetworking {
    private static final String PROTOCOL_VERSION = "1";

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(PROTOCOL_VERSION);
        registrar.playToClient(SyncOverlaysPayload.TYPE, SyncOverlaysPayload.STREAM_CODEC, (payload, context) -> UnderlayClient.handleSyncPacket(payload));
        registrar.playToClient(AddOverlayPayload.TYPE, AddOverlayPayload.STREAM_CODEC, (payload, context) -> UnderlayClient.handleAddPacket(payload));
        registrar.playBidirectional(RemoveOverlayPayload.TYPE, RemoveOverlayPayload.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler((payload, context) -> UnderlayClient.handleRemovePacket(payload), (payload, context) -> {
            BlockPos pos;
            ServerPlayer player = (ServerPlayer)context.player();
            ServerLevel world = player.serverLevel();
            if (!world.hasChunkAt(pos = payload.pos()) || !world.getWorldBorder().isWithinBounds(pos)) {
                return;
            }
            if (!world.mayInteract((Player)player, pos)) {
                return;
            }
            if (UnderlayManager.hasOverlay((Level)world, pos)) {
                BlockState oldState = UnderlayManager.getOverlay((Level)world, pos);
                UnderlayManager.removeOverlay((Level)world, pos);
                if (!player.isCreative()) {
                    world.addFreshEntity((Entity)new ItemEntity((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), new ItemStack((ItemLike)oldState.getBlock())));
                }
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)world, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new RemoveOverlayPayload(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }));
    }

    public static void syncOverlaysToPlayer(ServerPlayer player) {
        ServerLevel world = player.serverLevel();
        HashMap<BlockPos, CompoundTag> tags = new HashMap<BlockPos, CompoundTag>();
        UnderlayManager.getOverlaysFor((Level)world).forEach((pos, state) -> tags.put((BlockPos)pos, NbtUtils.writeBlockState((BlockState)state)));
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncOverlaysPayload(tags), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void broadcastAdd(ServerLevel world, BlockPos pos) {
        CompoundTag tag = NbtUtils.writeBlockState((BlockState)UnderlayManager.getOverlay((Level)world, pos));
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)world, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new AddOverlayPayload(pos, tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

