/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.mixin;

import com.dooji.underlay.client.UnderlayClient;
import com.dooji.underlay.client.UnderlayManagerClient;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @Inject(method={"startAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleInitialBreaking(CallbackInfoReturnable<Boolean> cir) {
        Minecraft client = Minecraft.getInstance();
        BlockPos overlayPos = UnderlayClient.findOverlayUnderCrosshair(client);
        if (overlayPos != null) {
            UnderlayClient.breakOverlay(client, overlayPos);
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Inject(method={"pickBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPickBlock(CallbackInfo ci) {
        Minecraft client = Minecraft.getInstance();
        BlockPos overlayPos = UnderlayClient.findOverlayUnderCrosshair(client);
        if (overlayPos != null) {
            BlockState underlayState = UnderlayManagerClient.getOverlay(overlayPos);
            if (client.player != null && client.player.getAbilities().instabuild) {
                ItemStack itemStack = underlayState.getBlock().asItem().getDefaultInstance();
                client.player.getInventory().setPickedItem(itemStack);
                if (client.gameMode != null) {
                    client.gameMode.handleCreativeModeItemAdd(itemStack, 36 + client.player.getInventory().selected);
                }
                ci.cancel();
            }
        }
    }
}

