/*
 * Decompiled with CFR 0.152.
 */
package net.combat_roll.mixin;

import net.combat_roll.CombatRollMod;
import net.combat_roll.config.ServerConfig;
import net.combat_roll.internals.RollManager;
import net.combat_roll.internals.RollingEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LocalPlayer.class})
public class ClientPlayerEntityMixin
implements RollingEntity {
    private RollManager rollManager = new RollManager();
    @Shadow
    @Final
    protected Minecraft minecraft;

    @Override
    public RollManager getRollManager() {
        return this.rollManager;
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void tick_TAIL(CallbackInfo ci) {
        LocalPlayer player = (LocalPlayer)this;
        if (player != null) {
            this.rollManager.tick(player);
        }
    }

    @Inject(method={"aiStep()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/Input;tick(ZF)V", shift=At.Shift.AFTER)})
    private void tickMovement_ModifyInput(CallbackInfo ci) {
        LocalPlayer clientPlayer = (LocalPlayer)this;
        ServerConfig config = CombatRollMod.config;
        if (!config.allow_jump_while_rolling && this.rollManager.isRolling()) {
            clientPlayer.input.jumping = false;
        }
    }

    @Inject(method={"canAutoJump()Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void shouldAutoJump_HEAD(CallbackInfoReturnable<Boolean> cir) {
        ServerConfig config = CombatRollMod.config;
        if (config != null && this.rollManager.isRolling() && !config.allow_auto_jump_while_rolling) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }
}

