/*
 * Decompiled with CFR 0.152.
 */
package net.combat_roll.mixin;

import net.combat_roll.CombatRollMod;
import net.combat_roll.Platform;
import net.combat_roll.api.CombatRoll;
import net.combat_roll.client.Keybindings;
import net.combat_roll.client.RollEffect;
import net.combat_roll.compatibility.BetterCombatHelper;
import net.combat_roll.internals.RollManager;
import net.combat_roll.internals.RollingEntity;
import net.combat_roll.network.Packets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class}, priority=449)
public abstract class MinecraftClientMixin {
    @Shadow
    private int rightClickDelay;
    @Shadow
    @Nullable
    public LocalPlayer player;

    @Inject(method={"startAttack()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void doAttack_HEAD(CallbackInfoReturnable<Boolean> info) {
        RollingEntity rollingPlayer = (RollingEntity)this.player;
        if (rollingPlayer != null && rollingPlayer.getRollManager().isRolling()) {
            info.setReturnValue((Object)false);
            info.cancel();
        }
    }

    @Inject(method={"continueAttack(Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleBlockBreaking_HEAD(boolean bl, CallbackInfo ci) {
        RollingEntity rollingPlayer = (RollingEntity)this.player;
        if (rollingPlayer != null && rollingPlayer.getRollManager().isRolling()) {
            ci.cancel();
        }
    }

    @Inject(method={"startUseItem()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void doItemUse_HEAD(CallbackInfo ci) {
        RollingEntity rollingPlayer = (RollingEntity)this.player;
        if (rollingPlayer != null && rollingPlayer.getRollManager().isRolling()) {
            ci.cancel();
        }
    }

    @Inject(method={"handleKeybinds()V"}, at={@At(value="TAIL")})
    private void handleInputEvents_TAIL(CallbackInfo ci) {
        this.tryRolling();
    }

    private void tryRolling() {
        Minecraft client = (Minecraft)this;
        if (this.player == null || client.isPaused() || client.screen != null) {
            return;
        }
        RollingEntity rollingPlayer = (RollingEntity)this.player;
        RollManager rollManager = rollingPlayer.getRollManager();
        if (Keybindings.roll.isDown()) {
            float defaultSlipperiness;
            Block block;
            float slipperiness;
            double liquidHeight;
            if (!rollManager.isRollAvailable((Player)this.player)) {
                return;
            }
            if (!CombatRollMod.config.allow_rolling_while_airborn && !this.player.onGround()) {
                return;
            }
            if ((float)this.player.getFoodData().getFoodLevel() <= CombatRollMod.config.food_level_required) {
                return;
            }
            if (this.player.isSwimming() || this.player.isVisuallyCrawling()) {
                return;
            }
            if (this.player.getVehicle() != null) {
                return;
            }
            if (this.player.isUsingItem() || this.player.isBlocking()) {
                return;
            }
            if (!CombatRollMod.config.allow_rolling_while_weapon_cooldown && (double)this.player.getAttackStrengthScale(0.0f) < 0.95) {
                return;
            }
            if (BetterCombatHelper.isDoingUpswing()) {
                BetterCombatHelper.cancelUpswing();
            } else if (client.options.keyAttack.isDown()) {
                return;
            }
            if (this.rightClickDelay > 0) {
                return;
            }
            float forward = this.player.input.forwardImpulse;
            float sideways = this.player.input.leftImpulse;
            Vec3 direction = forward == 0.0f && sideways == 0.0f ? new Vec3(0.0, 0.0, 1.0) : new Vec3((double)sideways, 0.0, (double)forward).normalize();
            direction = direction.yRot((float)Math.toRadians(-1.0 * (double)this.player.getYRot()));
            double distance = 0.475 * (this.player.getAttributeValue(CombatRoll.Attributes.DISTANCE.entry) + (double)CombatRollMod.config.additional_roll_distance);
            direction = direction.scale(distance);
            if (this.player.isInWater()) {
                liquidHeight = this.player.getFluidHeight(FluidTags.WATER);
                liquidHeight = Math.min(liquidHeight, 1.0);
                double multiplier = Math.max(1.0 - liquidHeight * 3.0, 0.3);
                direction = direction.scale(multiplier);
            }
            if (this.player.isInLava()) {
                liquidHeight = this.player.getFluidHeight(FluidTags.LAVA);
                liquidHeight = Math.min(liquidHeight, 1.0);
                direction = direction.scale(0.3);
            }
            if ((slipperiness = (block = this.player.level().getBlockState(this.player.blockPosition().below()).getBlock()).getFriction()) > (defaultSlipperiness = Blocks.GRASS_BLOCK.getFriction())) {
                float multiplier = defaultSlipperiness / slipperiness;
                direction = direction.scale((double)(multiplier * multiplier));
            }
            this.player.push(direction.x, direction.y, direction.z);
            rollManager.onRoll(this.player);
            RollEffect.Visuals rollVisuals = new RollEffect.Visuals("combat_roll:roll", RollEffect.Particles.PUFF);
            Platform.networkC2S_Send(new Packets.RollPublish(this.player.getId(), rollVisuals, direction));
            RollEffect.playVisuals(rollVisuals, (Player)this.player, direction);
        }
    }
}

