/*
 * Decompiled with CFR 0.152.
 */
package net.combat_roll.neoforge.network;

import com.google.gson.Gson;
import java.util.function.Consumer;
import net.combat_roll.CombatRollMod;
import net.combat_roll.client.ClientNetwork;
import net.combat_roll.network.Packets;
import net.combat_roll.network.ServerNetwork;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ConfigurationTask;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.configuration.ICustomConfigurationTask;
import net.neoforged.neoforge.network.event.RegisterConfigurationTasksEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="combat_roll", bus=EventBusSubscriber.Bus.MOD)
public class NetworkEvents {
    @SubscribeEvent
    public static void register(RegisterConfigurationTasksEvent event) {
        event.register((net.minecraft.server.network.ConfigurationTask)new ConfigurationTask(event.getListener()));
    }

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.configurationToServer(Packets.Ack.PACKET_ID, Packets.Ack.CODEC, (payload, context) -> {
            if (payload.code().equals(ConfigurationTask.ID.toString())) {
                context.finishCurrentTask(ConfigurationTask.KEY);
            }
        });
        registrar.playToServer(Packets.RollPublish.PACKET_ID, Packets.RollPublish.CODEC, (packet, context) -> {
            ServerPlayer player = (ServerPlayer)context.player();
            MinecraftServer server = player.server;
            ServerNetwork.handleRollPublish(packet, server, player);
        });
        registrar.configurationToClient(Packets.ConfigSync.PACKET_ID, Packets.ConfigSync.CODEC, (packet, context) -> {
            ClientNetwork.handleConfigSync(packet);
            context.reply((CustomPacketPayload)new Packets.Ack(ConfigurationTask.ID.toString()));
        });
        registrar.playToClient(Packets.RollAnimation.PACKET_ID, Packets.RollAnimation.CODEC, (packet, context) -> ClientNetwork.handleRollAnimation(packet));
    }

    public record ConfigurationTask(ServerConfigurationPacketListener listener) implements ICustomConfigurationTask
    {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"combat_roll", (String)"config");
        public static final ConfigurationTask.Type KEY = new ConfigurationTask.Type(ResourceLocation.fromNamespaceAndPath((String)"combat_roll", (String)"config"));

        public void run(Consumer<CustomPacketPayload> sender) {
            Gson gson = new Gson();
            String configString = gson.toJson((Object)CombatRollMod.config);
            Packets.ConfigSync configPayload = new Packets.ConfigSync(configString);
            sender.accept(configPayload);
        }

        public ConfigurationTask.Type type() {
            return KEY;
        }
    }
}

