/*
 * Decompiled with CFR 0.152.
 */
package net.critical_strike.api;

import java.util.ArrayList;
import net.critical_strike.api.AttributeIdentifiers;
import net.critical_strike.internal.CustomStatusEffect;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import org.jetbrains.annotations.Nullable;

public class CriticalStrikeAttributes {
    public static final String NAMESPACE = "critical_strike";
    public static final ArrayList<Entry> all = new ArrayList();
    public static final Entry CHANCE = CriticalStrikeAttributes.entry("chance", 100.0, 100.0, false).translations("Critical Hit Chance", "Critical Hit", "Increases the chance to deal critical hits.").innateModifier(AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.05f).effect(0xF400FF);
    public static final Entry DAMAGE = CriticalStrikeAttributes.entry("damage", 100.0, 100.0, false).translations("Critical Hit Damage", "Critical Impact", "Increases the damage dealt by critical hits.").innateModifier(AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.5f).effect(0x800000);

    private static Entry entry(String name, double baseValue, boolean tracked) {
        return CriticalStrikeAttributes.entry(name, 0.0, baseValue, tracked);
    }

    private static Entry entry(String name, double minValue, double baseValue, boolean tracked) {
        Entry entry = new Entry(name, minValue, baseValue, tracked);
        all.add(entry);
        return entry;
    }

    public static class Entry {
        public final ResourceLocation id;
        public final String translationKey;
        public final Attribute attribute;
        public final double baseValue;
        @Nullable
        public Holder<Attribute> attributeEntry;
        @Nullable
        public AttributeModifier innateModifier;
        @Nullable
        public Translations translations;
        @Nullable
        private MobEffect statusEffect = null;
        @Nullable
        public Holder<MobEffect> effectEntry = null;

        public Entry(String name, double minValue, double baseValue, boolean tracked) {
            this.id = ResourceLocation.fromNamespaceAndPath((String)CriticalStrikeAttributes.NAMESPACE, (String)name);
            this.translationKey = "attribute.name.critical_strike." + name;
            this.attribute = new RangedAttribute(this.translationKey, baseValue, minValue, 2048.0).setSyncable(tracked);
            this.baseValue = baseValue;
        }

        public double asMultiplier(double attributeValue) {
            return attributeValue / this.baseValue;
        }

        public float asChance(double attributeValue) {
            return (float)((attributeValue - this.baseValue) / this.baseValue);
        }

        public void register() {
            if (this.attributeEntry != null) {
                return;
            }
            this.attributeEntry = Registry.registerForHolder((Registry)BuiltInRegistries.ATTRIBUTE, (ResourceLocation)this.id, (Object)this.attribute);
        }

        public Entry innateModifier(AttributeModifier.Operation operation, float value) {
            this.innateModifier = new AttributeModifier(AttributeIdentifiers.INNATE_BONUS, (double)value, operation);
            return this;
        }

        public void setInnateBonus(float bonus) {
            if (this.innateModifier != null) {
                this.innateModifier = new AttributeModifier(this.innateModifier.id(), (double)bonus, this.innateModifier.operation());
            }
        }

        public Entry translations(String name, String effectName, String effectDescription) {
            this.translations = new Translations(name, effectName, effectDescription);
            return this;
        }

        public Entry effect(int color) {
            this.statusEffect = new CustomStatusEffect(MobEffectCategory.BENEFICIAL, color);
            return this;
        }

        public void setEffectBonus(float bonus) {
            if (this.statusEffect != null && this.attributeEntry != null) {
                this.statusEffect.addAttributeModifier(this.attributeEntry, AttributeIdentifiers.EFFECT_BONUS, (double)bonus, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
            }
        }

        public void registerEffect() {
            if (this.statusEffect != null) {
                this.effectEntry = Registry.registerForHolder((Registry)BuiltInRegistries.MOB_EFFECT, (ResourceLocation)this.id, (Object)this.statusEffect);
            }
        }

        public ResourceLocation potionId() {
            return ResourceLocation.fromNamespaceAndPath((String)this.id.getNamespace(), (String)(this.id.getNamespace() + "_" + this.id.getPath()));
        }
    }

    public record Translations(String name, String effectName, String effectDescription) {
    }
}

