/*
 * Decompiled with CFR 0.152.
 */
package net.critical_strike.client;

import net.critical_strike.client.CriticalStrikeClient;
import net.critical_strike.client.particle.TemplateParticleEffect;
import net.critical_strike.client.util.Color;
import net.critical_strike.fx.CriticalStrikeParticles;
import net.critical_strike.internal.ClientConfig;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ParticleHelper {
    public static void spawnCritParticles(Entity target) {
        Level level = target.level();
        if (level instanceof ClientLevel) {
            ClientLevel clientWorld = (ClientLevel)level;
            ClientConfig config = (ClientConfig)CriticalStrikeClient.config.value;
            float width = target.getBbWidth();
            double originX = target.getX();
            double originY = target.getY() + (double)(target.getBbHeight() * 0.5f);
            double originZ = target.getZ();
            Color color = Color.from(config.particle_alt_color);
            ParticleOptions spark = ParticleHelper.resolveParticleType(CriticalStrikeParticles.SPARKLE.id(), color, null);
            for (int i = 0; i < config.particle_spark_count; ++i) {
                float speed = config.particle_spark_speed;
                Vec3 velocity = new Vec3(1.0, 0.0, 0.0).yRot(clientWorld.random.nextFloat() * 360.0f).xRot(clientWorld.random.nextFloat() * 360.0f).scale((double)(speed + clientWorld.random.nextFloat() * (speed * 0.5f)));
                clientWorld.addParticle(spark, true, originX, originY, originZ, velocity.x, velocity.y, velocity.z);
            }
            if (!target.isAlive()) {
                return;
            }
            ParticleOptions skull = ParticleHelper.resolveParticleType(CriticalStrikeParticles.SKULL.id(), color, target);
            for (int i = 0; i < config.particle_skull_count; i += 2) {
                Vec3 offset = new Vec3((double)width, 0.0, 0.0).yRot(clientWorld.random.nextFloat() * 360.0f);
                Vec3 velocity = new Vec3(0.0, (double)0.1f, 0.0);
                clientWorld.addParticle(skull, true, originX + offset.x, originY + offset.y, originZ + offset.z, velocity.x, velocity.y, velocity.z);
                if (i + 1 >= config.particle_skull_count) break;
                offset = offset.reverse();
                clientWorld.addParticle(skull, true, originX + offset.x, originY + offset.y, originZ + offset.z, velocity.x, velocity.y, velocity.z);
            }
            ParticleOptions circle = ParticleHelper.resolveParticleType(CriticalStrikeParticles.CIRCLE.id(), color, target);
            clientWorld.addParticle(circle, true, originX, originY, originZ, 0.0, 0.0, 0.0);
        }
    }

    private static ParticleOptions resolveParticleType(ResourceLocation particleId, Color color, @Nullable Entity sourceEntity) {
        ParticleOptions particle = (ParticleOptions)BuiltInRegistries.PARTICLE_TYPE.get(particleId);
        if (particle instanceof TemplateParticleEffect) {
            TemplateParticleEffect templateParticleEffect = (TemplateParticleEffect)particle;
            TemplateParticleEffect copy = templateParticleEffect.copy();
            TemplateParticleEffect.Appearance appearance = copy.createOrDefaultAppearance();
            appearance.color = color;
            if (sourceEntity != null) {
                appearance.entityFollowed = sourceEntity;
            }
            particle = copy;
        }
        return particle;
    }
}

