/*
 * Decompiled with CFR 0.152.
 */
package net.critical_strike.internal;

import net.critical_strike.api.CriticalDamageSource;
import net.critical_strike.fx.CriticalStrikeSounds;
import net.critical_strike.internal.CriticalStriker;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CritLogic {
    public static boolean isWeapon(ItemStack itemStack) {
        ItemAttributeModifiers attributes = (ItemAttributeModifiers)itemStack.get(DataComponents.ATTRIBUTE_MODIFIERS);
        if (attributes == null || attributes.modifiers() == null || attributes.modifiers().isEmpty()) {
            return false;
        }
        for (ItemAttributeModifiers.Entry modifier : attributes.modifiers()) {
            if (!CritLogic.isHand(modifier.slot())) continue;
            return true;
        }
        return false;
    }

    private static boolean isHand(EquipmentSlotGroup slot) {
        return slot == EquipmentSlotGroup.MAINHAND || slot == EquipmentSlotGroup.OFFHAND || slot == EquipmentSlotGroup.HAND;
    }

    @Nullable
    public static Result modifyDamage(CriticalStriker critter, DamageSource source, float amount) {
        boolean isCritical = critter.rng_shouldDealCriticalHit();
        if (isCritical) {
            float bonusMultiplier = (float)critter.rng_criticalDamageMultiplier();
            ((CriticalDamageSource)source).rng_setCriticalDamageMultiplier(bonusMultiplier);
            return new Result(source, amount * bonusMultiplier);
        }
        return null;
    }

    public static void playFxAt(Entity target, float volume) {
        Level world = target.level();
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.getChunkSource().broadcastAndSend(target, (Packet)new ClientboundAnimatePacket(target, 43));
            float pitch = 0.9f + world.getRandom().nextFloat() * 0.2f;
            world.playSound(null, target.getX(), target.getY(), target.getZ(), CriticalStrikeSounds.CRITICAL_HIT.soundEvent(), SoundSource.PLAYERS, volume, pitch);
        }
    }

    public record Result(DamageSource source, float amount) {
    }
}

