/*
 * Decompiled with CFR 0.152.
 */
package net.skill_tree_rpgs.data_gen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public abstract class SkillDefinitionGenerator
implements DataProvider {
    private final CompletableFuture<HolderLookup.Provider> registryLookup;
    protected final FabricDataOutput dataOutput;
    private static final Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(Component.class, (Object)new Component.SerializerAdapter((HolderLookup.Provider)RegistryAccess.EMPTY)).setPrettyPrinting().create();

    public SkillDefinitionGenerator(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
        this.dataOutput = dataOutput;
        this.registryLookup = registryLookup;
    }

    public abstract void generate(Builder var1);

    public CompletableFuture<?> run(CachedOutput writer) {
        Builder builder = new Builder();
        this.generate(builder);
        List<Entry> entries = builder.entries;
        ArrayList<CompletableFuture> writes = new ArrayList<CompletableFuture>();
        for (Entry entry : entries) {
            LinkedHashMap<String, Format> content = entry.definitions();
            JsonElement json = gson.toJsonTree(content);
            Path path = this.getFilePath(entry.category());
            writes.add(DataProvider.saveStable((CachedOutput)writer, (JsonElement)json, (Path)path));
        }
        return CompletableFuture.allOf(writes.toArray(new CompletableFuture[0]));
    }

    public String getName() {
        return "Skill Definition Generator";
    }

    private Path getFilePath(ResourceLocation category) {
        return this.dataOutput.createPathProvider(PackOutput.Target.DATA_PACK, "puffish_skills/categories/" + category.getPath()).json(ResourceLocation.fromNamespaceAndPath((String)category.getNamespace(), (String)"definitions"));
    }

    public static class Builder {
        public final List<Entry> entries = new ArrayList<Entry>();
    }

    public record Entry(ResourceLocation category, LinkedHashMap<String, Format> definitions) {
    }

    public record RewardAttribute(String attribute, double value, String operation) {
        public static RewardAttribute from(Holder<Attribute> attribute, AttributeModifier modifier) {
            String operation = switch (modifier.operation()) {
                case AttributeModifier.Operation.ADD_VALUE -> "addition";
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> "multiply_base";
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> "multiply_total";
                default -> throw new IllegalArgumentException("Unknown operation: " + String.valueOf(modifier.operation()));
            };
            String attributeId = ((ResourceKey)attribute.unwrapKey().get()).location().toString();
            return new RewardAttribute(attributeId, modifier.amount(), operation);
        }
    }

    public record Reward(String type, Object data) {
    }

    public record IconEffect(String effect) {
    }

    public record IconItem(String item) {
    }

    public record IconTexture(String texture) {
    }

    public record Icon(String type, Object data) {
        public static Icon texture(String texture) {
            return new Icon("texture", new IconTexture(texture));
        }

        public static Icon item(String item) {
            return new Icon("item", new IconItem(item));
        }

        public static Icon effect(String effect) {
            return new Icon("effect", new IconEffect(effect));
        }
    }

    public record Translatable(String translate) {
    }

    public record Format(Translatable title, Component description, Icon icon, List<Reward> rewards, List<String> required_mods) {
    }
}

