/*
 * Decompiled with CFR 0.152.
 */
package net.skill_tree_rpgs.items;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.skill_tree_rpgs.utils.SkillHelper;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.ParticleHelper;
import net.spell_engine.fx.SpellEngineParticles;

public class RespecItem
extends Item {
    public static final ParticleBatch[] RESET_PARTICLES = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.CENTER, 30.0f, 0.2f, 0.25f).color(Color.from((int)0x8000FF).toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.CENTER, 30.0f, 0.2f, 0.25f).color(Color.from((int)0x8000FF).toRGBA()).invert()};

    public RespecItem(Item.Properties settings) {
        super(settings);
    }

    public SoundEvent getBreakingSound() {
        return SoundEvents.AMETHYST_CLUSTER_BREAK;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ServerPlayer serverUser;
        ItemStack itemStack = user.getItemInHand(hand);
        if (user instanceof ServerPlayer && SkillHelper.respec(serverUser = (ServerPlayer)user)) {
            user.awardStat(Stats.ITEM_USED.get((Object)this));
            EquipmentSlot equipmentSlot = user.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            itemStack.hurtAndBreak(1, ((ServerPlayer)user).serverLevel(), serverUser, item -> serverUser.onEquippedItemBroken(item, equipmentSlot));
            ParticleHelper.sendBatches((Entity)user, (ParticleBatch[])RESET_PARTICLES);
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)true);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }
}

