/*
 * Decompiled with CFR 0.152.
 */
package net.skill_tree_rpgs.node;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.reward.Reward;
import net.puffish.skillsmod.api.reward.RewardConfigContext;
import net.puffish.skillsmod.api.reward.RewardDisposeContext;
import net.puffish.skillsmod.api.reward.RewardUpdateContext;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.internals.container.SpellContainerSource;

public class SpellContainerReward
implements Reward {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"skill_tree_rpgs", (String)"spell");
    private static final Gson gson = new GsonBuilder().create();
    private ResourceLocation id;
    private List<SpellContainer> containers = List.of();

    public static void register() {
        SkillsAPI.registerReward((ResourceLocation)ID, SpellContainerReward::parse);
    }

    private static Result<SpellContainerReward, Problem> parse(RewardConfigContext context) {
        Result dataResult = context.getData();
        if (dataResult.getFailure().isPresent()) {
            return Result.failure((Object)((Problem)dataResult.getFailure().get()));
        }
        Optional data = dataResult.getSuccess();
        SpellContainerReward reward = new SpellContainerReward();
        try {
            com.google.gson.JsonElement json = ((JsonElement)data.get()).getJson();
            DataStructure parsedContainers = (DataStructure)gson.fromJson(json, DataStructure.class);
            String idString = (String)parsedContainers.containers().getFirst().spell_ids().getFirst();
            reward.id = ResourceLocation.parse((String)idString);
            reward.containers = parsedContainers.containers();
        }
        catch (Exception e) {
            return Result.failure((Object)Problem.message((String)("Failed to parse spell container reward" + e.getMessage())));
        }
        return Result.success((Object)reward);
    }

    public void update(RewardUpdateContext context) {
        int count = context.getCount();
        ServerPlayer player = context.getPlayer();
        LinkedHashMap containers = ((SpellContainerSource.Owner)player).serverSideSpellContainers();
        containers.remove(this.id.toString());
        if (count > 0) {
            int index = Math.min(count - 1, this.containers.size() - 1);
            containers.put(this.id.toString(), this.containers.get(index));
        }
        SpellContainerSource.setDirtyServerSide((Player)player);
    }

    public void dispose(RewardDisposeContext context) {
    }

    public record DataStructure(List<SpellContainer> containers) {
    }
}

