/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.dungeon_difficulty.config.ClientConfig;
import net.dungeon_difficulty.config.Config;
import net.dungeon_difficulty.config.Default;
import net.dungeon_difficulty.logic.DifficultyHandler;
import net.dungeon_difficulty.logic.DifficultyTypes;
import net.dungeon_difficulty.logic.ItemScaling;
import net.dungeon_difficulty.logic.LocalScalingLootFunction;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.tiny_config.ConfigManager;

public class DungeonDifficulty {
    public static final String MODID = "dungeon_difficulty";
    public static ConfigManager<Config> config = new ConfigManager("difficulty_v2", (Object)Default.config).builder().setDirectory("dungeon_difficulty").sanitize(true).build();
    public static ConfigManager<ClientConfig> clientConfig = new ConfigManager("client_settings", (Object)new ClientConfig()).builder().setDirectory("dungeon_difficulty").sanitize(true).build();

    public static void init() {
        clientConfig.refresh();
        DungeonDifficulty.reloadConfig();
        ItemScaling.initialize();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"dungeon_difficulty_config_reload").executes(context -> {
            System.out.println("Reloading Dungeon Difficulty config");
            DungeonDifficulty.reloadConfig();
            try {
                for (ServerPlayer player : ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers()) {
                    ((DifficultyHandler)player).getLastDifficultyAnnouncements().clear();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 1;
        })));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"power_level").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"players");
            int level = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
            if (level < 0) {
                level = 0;
            }
            for (ServerPlayer player : players) {
                ItemStack heldItemStack = player.getMainHandItem();
                ItemScaling.rescale(heldItemStack, level);
            }
            return 1;
        })))));
    }

    public static void reloadConfig() {
        config.load();
        Config config = (Config)DungeonDifficulty.config.value;
        if (config.meta != null) {
            DungeonDifficulty.config.sanitize = config.meta.sanitize_config;
        }
        DifficultyTypes.resolve();
        DungeonDifficulty.config.save();
    }

    public static void registerLootFunctions() {
        Registry.register((Registry)BuiltInRegistries.LOOT_FUNCTION_TYPE, (ResourceLocation)LocalScalingLootFunction.ID, LocalScalingLootFunction.TYPE);
    }
}

