/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.logic;

import java.util.Locale;
import java.util.Objects;
import net.dungeon_difficulty.config.Config;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public record Difficulty(Config.DifficultyType type, int level, int entityLevel, int rewardLevel) {
    private static final Config.DifficultyType EMPTY_TYPE = new Config.DifficultyType("empty");
    public static final Difficulty EMPTY = new Difficulty(EMPTY_TYPE, 0, 0, 0);

    public Difficulty withType(Config.DifficultyType newType) {
        return new Difficulty(newType, this.level, this.entityLevel, this.rewardLevel);
    }

    public boolean isValid() {
        return this.type != null && this.level > 0;
    }

    public boolean typeEquals(Difficulty other) {
        return this.type.name.equals(other.type.name) && this.level == other.level;
    }

    public String typeTranslationKey() {
        String suffix = this.type.translation_code != null ? this.type.translation_code : this.type.name;
        return "difficulty.type." + suffix.toLowerCase(Locale.ENGLISH);
    }

    public boolean allowsLootScaling() {
        return this.type.allow_loot_scaling != null && this.type.allow_loot_scaling != false;
    }

    public record Announcement(Difficulty difficulty, int age, String dimensionId, @Nullable ResourceLocation matchId) {
        public static Announcement EMPTY = new Announcement(EMPTY, 0, "", null);

        public boolean equals(Announcement other) {
            if (other == null) {
                return false;
            }
            return this.difficulty.typeEquals(other.difficulty) && Objects.equals(this.dimensionId, other.dimensionId) && Objects.equals(this.matchId, other.matchId);
        }
    }
}

