/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.logic;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.dungeon_difficulty.DungeonDifficulty;
import net.dungeon_difficulty.config.Config;

public class DifficultyTypes {
    public static List<Config.DifficultyType> resolved = List.of();

    public static void resolve() {
        ArrayList<Config.DifficultyType> resolved = new ArrayList<Config.DifficultyType>();
        List<Config.DifficultyType> types = ((Config)DungeonDifficulty.config.value).difficulty_types;
        for (Config.DifficultyType type : ((Config)DungeonDifficulty.config.value).difficulty_types) {
            resolved.add(DifficultyTypes.resolve(type, types));
        }
        DifficultyTypes.resolved = resolved;
    }

    private static Config.DifficultyType resolve(Config.DifficultyType type, List<Config.DifficultyType> types) {
        Config.DifficultyType parent;
        if (type.parent != null && !type.parent.isEmpty() && (parent = (Config.DifficultyType)types.stream().filter(otherType -> type.parent.equals(otherType.name)).findFirst().orElse(null)) != null) {
            parent = DifficultyTypes.resolve(parent, types);
            return DifficultyTypes.merge(type, parent);
        }
        return type;
    }

    private static Config.DifficultyType copy(Config.DifficultyType type) {
        Config.DifficultyType copy = new Config.DifficultyType();
        copy.name = type.name;
        copy.parent = type.parent;
        copy.entities = type.entities;
        return copy;
    }

    private static Config.DifficultyType merge(Config.DifficultyType t1, Config.DifficultyType t2) {
        Config.DifficultyType merged = DifficultyTypes.copy(t1);
        merged.entities = Stream.concat(t1.entities.stream(), t2.entities.stream()).toList();
        merged.allow_loot_scaling = t2.allow_loot_scaling;
        if (t1.allow_loot_scaling != null) {
            merged.allow_loot_scaling = t1.allow_loot_scaling;
        }
        return merged;
    }
}

