/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.logic;

import java.util.ArrayList;
import java.util.Map;
import net.dungeon_difficulty.config.Config;
import net.dungeon_difficulty.logic.EntityDifficultyScalable;
import net.dungeon_difficulty.logic.MathHelper;
import net.dungeon_difficulty.logic.PatternMatching;
import net.dungeon_difficulty.logic.PerPlayerDifficulty;
import net.dungeon_difficulty.mixin.AccessorAttributeContainer;
import net.dungeon_difficulty.mixin.AccessorDefaultAttributeContainer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;

public class EntityScaling {
    public static void scale(Entity entity, ServerLevel world) {
        if (entity instanceof Player) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            EntityDifficultyScalable scalableEntity = (EntityDifficultyScalable)livingEntity;
            if (scalableEntity.isAlreadyScaled()) {
                return;
            }
            PatternMatching.LocationData locationData = PatternMatching.LocationData.create(world, livingEntity.blockPosition());
            PatternMatching.EntityData entityData = PatternMatching.EntityData.create(livingEntity);
            scalableEntity.setScalingLocationData(locationData);
            float relativeHealth = livingEntity.getHealth() / livingEntity.getMaxHealth();
            EntityScaling.apply(PerPlayerDifficulty.getAttributeModifiers(entityData, world), livingEntity);
            PatternMatching.EntityScaleResult locationScaling = PatternMatching.getAttributeModifiersForEntity(locationData, entityData, world);
            EntityScaling.apply(locationScaling, livingEntity);
            scalableEntity.markAlreadyScaled(locationScaling.level());
            livingEntity.setHealth(relativeHealth * livingEntity.getMaxHealth());
        }
    }

    private static void apply(PatternMatching.EntityScaleResult scaling, LivingEntity entity) {
        int level = scaling.level();
        if (level <= 0) {
            return;
        }
        for (Config.AttributeModifier modifier : scaling.modifiers()) {
            String pattern = modifier.attribute;
            if (pattern == null || pattern.isEmpty()) continue;
            ArrayList<Object> matchingAttributes = new ArrayList<Object>();
            if (pattern.startsWith("~")) {
                String regex = pattern.substring("~".length());
                Map<Holder<Attribute>, AttributeInstance> instances = ((AccessorDefaultAttributeContainer)((Object)((AccessorAttributeContainer)entity.getAttributes()))).getInstances();
                for (Map.Entry<Holder<Attribute>, AttributeInstance> entry : instances.entrySet()) {
                    String id;
                    Holder<Attribute> holder = entry.getKey();
                    if (holder == null || holder.value() == null || !PatternMatching.regexMatches(id = ((Attribute)holder.value()).toString(), regex)) continue;
                    matchingAttributes.add(entry.getKey());
                }
            } else {
                Holder.Reference attribute = BuiltInRegistries.ATTRIBUTE.getHolder(ResourceLocation.parse((String)modifier.attribute)).orElse(null);
                if (attribute == null || !entity.getAttributes().hasAttribute((Holder)attribute)) continue;
                matchingAttributes.add(attribute);
            }
            float modifierValue = modifier.randomizedValue(level);
            float roundingUnit = modifier.value * 0.25f;
            modifierValue = (float)MathHelper.round(modifierValue, roundingUnit);
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"dungeon_difficulty", (String)scaling.name());
            for (Holder holder : matchingAttributes) {
                AttributeModifier.Operation operation = switch (modifier.operation) {
                    default -> throw new MatchException(null, null);
                    case Config.Operation.ADDITION -> AttributeModifier.Operation.ADD_VALUE;
                    case Config.Operation.MULTIPLY_BASE -> AttributeModifier.Operation.ADD_MULTIPLIED_BASE;
                };
                AttributeModifier entityModifier = new AttributeModifier(id, (double)modifierValue, operation);
                AttributeInstance instance = entity.getAttribute(holder);
                if (instance == null || instance.hasModifier(id)) continue;
                instance.addPermanentModifier(entityModifier);
            }
        }
    }
}

